/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.activities.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.sendbird.uikit.activities.adapter.BaseAdapter;
import com.sendbird.uikit.activities.viewholder.BaseViewHolder;
import com.sendbird.uikit.databinding.SbViewMemberPreviewBinding;
import com.sendbird.uikit.databinding.SbViewUserPreviewBinding;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import com.sendbird.uikit.interfaces.OnItemLongClickListener;
import com.sendbird.uikit.interfaces.UserInfo;
import com.sendbird.uikit.vm.UserListViewModel;
import java.util.Collections;
import java.util.List;

public class UserListAdapter
extends BaseAdapter<UserInfo, BaseViewHolder<UserInfo>> {
    public static final int USER_TYPE = 0;
    public static final int MEMBER_TYPE = 1;
    private List<UserInfo> userList;
    private UserListViewModel userListViewModel;
    private OnItemClickListener<UserInfo> listener;
    private OnItemLongClickListener<UserInfo> longClickListener;
    private int viewType = 0;

    public UserListAdapter() {
        this.setHasStableIds(true);
    }

    public UserListAdapter(int viewType) {
        this.setHasStableIds(true);
        this.viewType = viewType;
    }

    public UserListAdapter(OnItemClickListener<UserInfo> listener) {
        this.setHasStableIds(true);
        this.viewType = 1;
        this.listener = listener;
    }

    @NonNull
    public BaseViewHolder<UserInfo> onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == 1) {
            return new MemberPreviewHolder(SbViewMemberPreviewBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false));
        }
        return new UserPreviewHolder(SbViewUserPreviewBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false));
    }

    public void onBindViewHolder(@NonNull BaseViewHolder<UserInfo> holder, int position) {
        UserInfo userInfo = this.getItem(position);
        holder.itemView.setOnClickListener(v -> {
            int userPosition = holder.getAdapterPosition();
            if (userPosition != -1 && this.listener != null) {
                this.listener.onItemClick(v, userPosition, this.getItem(userPosition));
            }
        });
        holder.itemView.setOnLongClickListener(v -> {
            int userPosition = holder.getAdapterPosition();
            if (userPosition != -1 && this.longClickListener != null) {
                this.longClickListener.onItemLongClick(v, userPosition, this.getItem(userPosition));
                return true;
            }
            return false;
        });
        holder.bind(userInfo);
    }

    @Override
    public UserInfo getItem(int position) {
        return this.userList.get(position);
    }

    @Override
    public List<UserInfo> getItems() {
        return this.userList != null ? Collections.unmodifiableList(this.userList) : null;
    }

    public int getItemCount() {
        return this.userList == null ? 0 : this.userList.size();
    }

    public long getItemId(int position) {
        return this.getItem(position).hashCode();
    }

    public int getItemViewType(int position) {
        return this.viewType;
    }

    public void setItems(List<UserInfo> userList) {
        this.userList = userList;
        this.notifyDataSetChanged();
    }

    public void setUserListViewModel(UserListViewModel userListViewModel) {
        this.userListViewModel = userListViewModel;
    }

    public void setOnItemClickListener(@Nullable OnItemClickListener<UserInfo> listener) {
        this.listener = listener;
    }

    public void setOnItemLongClickListener(@Nullable OnItemLongClickListener<UserInfo> listener) {
        this.longClickListener = listener;
    }

    private class MemberPreviewHolder
    extends BaseViewHolder<UserInfo> {
        private SbViewMemberPreviewBinding binding;

        MemberPreviewHolder(SbViewMemberPreviewBinding binding) {
            super(binding.getRoot());
            this.binding = binding;
        }

        @Override
        public void bind(UserInfo user) {
            this.binding.setUser(user);
            this.binding.executePendingBindings();
        }
    }

    private class UserPreviewHolder
    extends BaseViewHolder<UserInfo> {
        private SbViewUserPreviewBinding binding;

        UserPreviewHolder(SbViewUserPreviewBinding binding) {
            super(binding.getRoot());
            this.binding = binding;
        }

        @Override
        public void bind(UserInfo user) {
            this.binding.setUser(user);
            this.binding.setUserListViewModel(UserListAdapter.this.userListViewModel);
            this.binding.executePendingBindings();
        }
    }
}

