/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.dialogs;

import android.app.Dialog;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.sendbird.uikit.R;
import com.sendbird.uikit.databinding.SbViewDialogListItemBinding;
import com.sendbird.uikit.dialogs.DialogHelper;
import com.sendbird.uikit.utils.DrawableUtils;

class DialogListAdapter
extends RecyclerView.Adapter<ListViewHolder> {
    private DialogHelper.DialogListItem[] items;
    private DialogHelper.DialogResultListener listener;
    private Dialog dialog;
    private int nameMarginLeft = R.dimen.sb_size_24;
    private boolean isIconLeft;

    DialogListAdapter(DialogHelper.DialogListItem[] items, DialogHelper.DialogResultListener listener, boolean isIconLeft) {
        this.items = items;
        this.listener = listener;
        this.isIconLeft = isIconLeft;
    }

    void setDialog(Dialog dialog) {
        this.dialog = dialog;
    }

    void setNameMarginLeft(int resId) {
        this.nameMarginLeft = resId;
    }

    @NonNull
    public ListViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ListViewHolder(SbViewDialogListItemBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false));
    }

    public void onBindViewHolder(@NonNull ListViewHolder holder, int position) {
        holder.bind(position);
    }

    public int getItemCount() {
        return this.items == null ? 0 : this.items.length;
    }

    class ListViewHolder
    extends RecyclerView.ViewHolder {
        private SbViewDialogListItemBinding binding;
        private Context context;
        private int listItemAppearance;
        private ColorStateList buttonTint;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ListViewHolder(SbViewDialogListItemBinding binding) {
            super(binding.getRoot());
            this.binding = binding;
            this.context = binding.getRoot().getContext();
            TypedArray a = this.context.getTheme().obtainStyledAttributes(null, R.styleable.DialogView, R.attr.sb_dialog_view_style, 0);
            try {
                this.listItemAppearance = a.getResourceId(R.styleable.DialogView_sb_dialog_view_list_item_appearance, R.style.SendbirdSubtitle2OnLight01);
                int listItemBackground = a.getResourceId(R.styleable.DialogView_sb_dialog_view_list_item_background, R.drawable.selector_rectangle_light);
                this.buttonTint = a.getColorStateList(R.styleable.DialogView_sb_dialog_view_icon_tint);
                this.binding.clItem.setBackgroundResource(listItemBackground);
                ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)binding.name.getLayoutParams();
                params.setMargins((int)this.context.getResources().getDimension(DialogListAdapter.this.nameMarginLeft), 0, 0, 0);
            }
            finally {
                a.recycle();
            }
        }

        private void bind(int position) {
            DialogHelper.DialogListItem item = DialogListAdapter.this.items[position];
            if (item != null && item.getKey() != 0) {
                this.binding.name.setText(item.getKey());
                this.binding.name.setTextAppearance(this.context, this.listItemAppearance);
            }
            if (item != null && item.getIcon() != 0) {
                Drawable icon = DrawableUtils.setTintList(this.itemView.getContext(), item.getIcon(), this.buttonTint);
                if (DialogListAdapter.this.isIconLeft) {
                    this.binding.iconLeft.setVisibility(0);
                    this.binding.iconLeft.setImageDrawable(icon);
                } else {
                    this.binding.iconRight.setVisibility(0);
                    this.binding.iconRight.setImageDrawable(icon);
                }
            }
            this.binding.getRoot().setOnClickListener(v -> {
                if (DialogListAdapter.this.listener != null && item != null && item.getKey() != 0) {
                    DialogListAdapter.this.listener.onResult(item.getKey());
                }
                if (DialogListAdapter.this.dialog != null) {
                    DialogListAdapter.this.dialog.dismiss();
                }
            });
        }
    }
}

