/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.activities;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.dialogs.DialogHelper;
import com.sendbird.uikit.fragments.ChannelFragment;
import com.sendbird.uikit.utils.TextUtils;

public class ChannelActivity
extends AppCompatActivity {
    public static Intent newIntent(@NonNull Context context, @NonNull String channelUrl) {
        Intent intent = new Intent(context, ChannelActivity.class);
        intent.putExtra("KEY_CHANNEL_URL", channelUrl);
        return intent;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setTheme(SendBirdUIKit.isDarkMode() ? R.style.SendBird_Dark : R.style.SendBird);
        this.setContentView(R.layout.sb_activity);
        String url = this.getIntent().getStringExtra("KEY_CHANNEL_URL");
        if (TextUtils.isEmpty(url)) {
            DialogHelper.toastError((Context)this, R.string.sb_text_error_get_channel);
        } else {
            ChannelFragment fragment = this.createChannelFragment(url);
            FragmentManager manager = this.getSupportFragmentManager();
            manager.popBackStack();
            manager.beginTransaction().replace(R.id.sb_fragment_container, (Fragment)fragment).commit();
        }
    }

    protected ChannelFragment createChannelFragment(@NonNull String channelUrl) {
        return new ChannelFragment.Builder(channelUrl).setUseHeader(true).build();
    }
}

