/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.vm;

import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.SendBirdException;
import com.sendbird.uikit.log.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

class MessageChangeLogsPager {
    private final BaseChannel channel;
    private final long lastSyncAt;

    MessageChangeLogsPager(BaseChannel channel, long lastSyncAt) {
        this.channel = channel;
        this.lastSyncAt = lastSyncAt;
    }

    void load(MessageChangeLogsResultHandler handler) {
        Executors.newSingleThreadExecutor().execute(() -> {
            block6: {
                ArrayList<BaseMessage> updatedMessageList = new ArrayList<BaseMessage>();
                ArrayList<BaseMessage> addedMessageList = new ArrayList<BaseMessage>();
                ArrayList<Long> deletedMessageIdList = new ArrayList<Long>();
                CountDownLatch lock = new CountDownLatch(1);
                AtomicReference tokenRef = new AtomicReference();
                AtomicBoolean hasMoreRef = new AtomicBoolean();
                try {
                    List<BaseMessage> list;
                    boolean hasMore2;
                    this.load(this.lastSyncAt, (updated, deletedMessageIds, hasMore, token, e) -> {
                        if (e != null) {
                            if (handler != null) {
                                handler.onError(e);
                            }
                            return;
                        }
                        tokenRef.set(token);
                        hasMoreRef.set(hasMore);
                        updatedMessageList.addAll(updated);
                        deletedMessageIdList.addAll(deletedMessageIds);
                        lock.countDown();
                    });
                    lock.await();
                    while (hasMoreRef.get()) {
                        CountDownLatch moreLock = new CountDownLatch(1);
                        this.more((String)tokenRef.get(), (updated, deletedMessageIds, hasMore, token, e) -> {
                            if (e != null) {
                                if (handler != null) {
                                    handler.onError(e);
                                }
                                return;
                            }
                            tokenRef.set(token);
                            hasMoreRef.set(hasMore);
                            updatedMessageList.addAll(updated);
                            deletedMessageIdList.addAll(deletedMessageIds);
                            moreLock.countDown();
                        });
                        moreLock.await();
                    }
                    long timeStamp = this.lastSyncAt;
                    do {
                        int totalSize;
                        if ((totalSize = addedMessageList.size()) > 0) {
                            timeStamp = ((BaseMessage)addedMessageList.get(0)).getCreatedAt();
                        }
                        list = this.loadAddedMessageFromTimestamp(timeStamp);
                        addedMessageList.addAll(0, list);
                    } while (hasMore2 = list.size() > 0);
                    if (handler != null) {
                        handler.onResult(addedMessageList, updatedMessageList, deletedMessageIdList);
                    }
                }
                catch (Exception e2) {
                    Logger.e(e2);
                    if (handler == null) break block6;
                    handler.onError(new SendBirdException(e2.getMessage(), 800220));
                }
            }
        });
    }

    private void load(long ts, BaseChannel.GetMessageChangeLogsHandler handler) {
        this.channel.getMessageChangeLogsByTimestamp(ts, handler);
    }

    private void more(String token, BaseChannel.GetMessageChangeLogsByTokenHandler handler) {
        this.channel.getMessageChangeLogsByToken(token, handler);
    }

    private List<BaseMessage> loadAddedMessageFromTimestamp(long ts) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference result = new AtomicReference();
        AtomicReference error = new AtomicReference();
        this.channel.getNextMessagesByTimestamp(ts, false, 100, true, BaseChannel.MessageTypeFilter.ALL, null, (messages, e) -> {
            try {
                if (e != null) {
                    error.set(e);
                    return;
                }
                result.set(messages);
            }
            finally {
                latch.countDown();
            }
        });
        latch.await();
        if (error.get() != null) {
            throw (Exception)error.get();
        }
        return (List)result.get();
    }

    static interface MessageChangeLogsResultHandler {
        public void onError(SendBirdException var1);

        public void onResult(List<BaseMessage> var1, List<BaseMessage> var2, List<Long> var3);
    }
}

