/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import com.sendbird.uikit.R;
import com.sendbird.uikit.databinding.SbViewMessageInputBinding;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.utils.TextUtils;
import java.lang.reflect.Field;

public class MessageInputView
extends FrameLayout {
    private SbViewMessageInputBinding binding;

    public MessageInputView(@NonNull Context context) {
        this(context, null);
    }

    public MessageInputView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.sb_message_input_style);
    }

    public MessageInputView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MessageInput, defStyleAttr, 0);
        try {
            this.binding = (SbViewMessageInputBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.getContext()), (int)R.layout.sb_view_message_input, (ViewGroup)this, (boolean)true);
            int backgroundId = a.getResourceId(R.styleable.MessageInput_sb_message_input_background, R.color.background_100);
            int textBackgroundId = a.getResourceId(R.styleable.MessageInput_sb_message_input_text_background, R.drawable.sb_message_input_text_background_light);
            int textAppearance = a.getResourceId(R.styleable.MessageInput_sb_message_input_text_appearance, R.style.SendbirdBody2OnLight01);
            ColorStateList hintColor = a.getColorStateList(R.styleable.MessageInput_sb_message_input_text_hint_color);
            int textCursorDrawable = a.getResourceId(R.styleable.MessageInput_sb_message_input_text_cursor_drawable, R.drawable.sb_message_input_cursor_light);
            this.binding.messageInputParent.setBackgroundResource(backgroundId);
            this.binding.etInputText.setBackgroundResource(textBackgroundId);
            this.binding.etInputText.setTextAppearance(context, textAppearance);
            if (hintColor != null) {
                this.binding.etInputText.setHintTextColor(hintColor);
            }
            if (Build.VERSION.SDK_INT >= 29) {
                this.binding.etInputText.setTextCursorDrawable(textCursorDrawable);
            } else {
                Field f = TextView.class.getDeclaredField("mCursorDrawableRes");
                f.setAccessible(true);
                f.set(this.binding.etInputText, textCursorDrawable);
            }
        }
        catch (Exception e) {
            Logger.e(e);
        }
        finally {
            a.recycle();
        }
    }

    public void showEditMode(CharSequence text) {
        this.binding.etInputText.setText(text);
        this.binding.ibtnAdd.setVisibility(8);
        this.binding.editPanel.setVisibility(0);
        if (!TextUtils.isEmpty(text)) {
            this.binding.etInputText.setSelection(text.length());
        }
    }

    public void hideEditMode() {
        this.binding.etInputText.setText((CharSequence)"");
        this.binding.ibtnAdd.setVisibility(0);
        this.binding.editPanel.setVisibility(8);
    }

    public SbViewMessageInputBinding getBinding() {
        return this.binding;
    }

    public View getLayout() {
        return this;
    }
}

