/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.vm;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.OnLifecycleEvent;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.FileMessage;
import com.sendbird.android.FileMessageParams;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.Member;
import com.sendbird.android.ReadStatus;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.android.UserMessage;
import com.sendbird.uikit.R;
import com.sendbird.uikit.interfaces.DialogProvider;
import com.sendbird.uikit.interfaces.OnResultHandler;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.ChatMessageCollection;
import com.sendbird.uikit.model.FileInfo;
import com.sendbird.uikit.tasks.JobResultTask;
import com.sendbird.uikit.tasks.TaskQueue;
import com.sendbird.uikit.utils.FileUtils;
import com.sendbird.uikit.vm.BaseViewModel;
import com.sendbird.uikit.vm.FileDownloader;
import com.sendbird.uikit.vm.MessageChangeLogsPager;
import com.sendbird.uikit.vm.PendingMessageRepository;
import com.sendbird.uikit.widgets.PagerRecyclerView;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;

public class ChannelViewModel
extends BaseViewModel
implements LifecycleObserver,
PagerRecyclerView.Pageable {
    private static final int DEFAULT_MESSAGE_LOAD_SIZE = 40;
    private static final String CONNECTION_HANDLER_ID = "CONNECTION_HANDLER_GROUP_CHAT";
    private static final String CHANNEL_HANDLER_ID = "CHANNEL_HANDLER_GROUP_CHANNEL_CHAT";
    private final ExecutorService worker = Executors.newSingleThreadExecutor();
    private final MutableLiveData<List<BaseMessage>> messageList = new MutableLiveData();
    private final ChatMessageCollection messageCollection = new ChatMessageCollection();
    private final MutableLiveData<List<Member>> typingMembers = new MutableLiveData();
    private final MutableLiveData<Boolean> isChannelChanged = new MutableLiveData();
    private final MutableLiveData<Boolean> channelDeleted = new MutableLiveData();
    private final MutableLiveData<Long> lastSeenAt = new MutableLiveData();
    private GroupChannel channel;
    private boolean hasMore = false;

    ChannelViewModel(DialogProvider provider, GroupChannel groupChannel) {
        super(provider);
        this.channel = groupChannel;
    }

    public boolean isCurrentChannel(@NonNull String channelUrl) {
        return channelUrl.equals(this.channel.getUrl());
    }

    public MutableLiveData<Boolean> isChannelChanged() {
        return this.isChannelChanged;
    }

    public MutableLiveData<Boolean> getChannelDeleted() {
        return this.channelDeleted;
    }

    public GroupChannel getChannel() {
        return this.channel;
    }

    public LiveData<List<BaseMessage>> getMessageList() {
        return this.messageList;
    }

    public MutableLiveData<List<Member>> getTypingMembers() {
        return this.typingMembers;
    }

    public MutableLiveData<Long> getLastSeenAt() {
        return this.lastSeenAt;
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
    private void onResume() {
        SendBird.addConnectionHandler((String)CONNECTION_HANDLER_ID, (SendBird.ConnectionHandler)new SendBird.ConnectionHandler(){

            public void onReconnectStarted() {
            }

            public void onReconnectSucceeded() {
                ChannelViewModel.this.requestChangeLogs((BaseChannel)ChannelViewModel.this.channel);
            }

            public void onReconnectFailed() {
            }
        });
        SendBird.addChannelHandler((String)CHANNEL_HANDLER_ID, (SendBird.ChannelHandler)new SendBird.ChannelHandler(){

            public void onMessageReceived(BaseChannel baseChannel, BaseMessage baseMessage) {
                Logger.d("++ onMessageReceived(%s)", baseMessage.getMessageId());
                if (ChannelViewModel.this.isCurrentChannel(baseChannel.getUrl())) {
                    ChannelViewModel.this.channel = (GroupChannel)baseChannel;
                    ChannelViewModel.this.messageCollection.add(baseMessage);
                    ChannelViewModel.this.notifyDataSetChanged();
                    ChannelViewModel.this.markAsRead();
                }
            }

            public void onUserJoined(GroupChannel channel, User user) {
                if (ChannelViewModel.this.isCurrentChannel(channel.getUrl())) {
                    ChannelViewModel.this.channel = channel;
                    ChannelViewModel.this.isChannelChanged.postValue((Object)true);
                    ChannelViewModel.this.notifyDataSetChanged();
                }
            }

            public void onUserLeft(GroupChannel channel, User user) {
                if (ChannelViewModel.this.isCurrentChannel(channel.getUrl())) {
                    ChannelViewModel.this.channel = channel;
                    ChannelViewModel.this.isChannelChanged.postValue((Object)true);
                    ChannelViewModel.this.notifyDataSetChanged();
                }
            }

            public void onMessageDeleted(BaseChannel baseChannel, long msgId) {
                Logger.d("++ onMessageDeleted(%s)", msgId);
                if (ChannelViewModel.this.isCurrentChannel(baseChannel.getUrl())) {
                    ChannelViewModel.this.channel = (GroupChannel)baseChannel;
                    ChannelViewModel.this.messageCollection.removeByMessageId(msgId);
                    ChannelViewModel.this.notifyDataSetChanged();
                }
            }

            public void onMessageUpdated(BaseChannel baseChannel, BaseMessage updatedMessage) {
                Logger.d("++ onMessageUpdated(%s)", updatedMessage.getMessageId());
                if (ChannelViewModel.this.isCurrentChannel(baseChannel.getUrl())) {
                    ChannelViewModel.this.channel = (GroupChannel)baseChannel;
                    ChannelViewModel.this.messageCollection.update(updatedMessage);
                    ChannelViewModel.this.notifyDataSetChanged();
                }
            }

            public void onReadReceiptUpdated(GroupChannel baseChannel) {
                if (ChannelViewModel.this.isCurrentChannel(baseChannel.getUrl())) {
                    ChannelViewModel.this.channel = baseChannel;
                    ChannelViewModel.this.notifyDataSetChanged();
                }
            }

            public void onDeliveryReceiptUpdated(GroupChannel channel) {
                if (ChannelViewModel.this.isCurrentChannel(channel.getUrl())) {
                    ChannelViewModel.this.channel = channel;
                    ChannelViewModel.this.notifyDataSetChanged();
                }
            }

            public void onTypingStatusUpdated(GroupChannel channel) {
                if (ChannelViewModel.this.isCurrentChannel(channel.getUrl())) {
                    List typingUsers = channel.getTypingMembers();
                    if (typingUsers.size() > 0) {
                        ChannelViewModel.this.typingMembers.postValue((Object)typingUsers);
                    } else {
                        ChannelViewModel.this.typingMembers.postValue(null);
                    }
                }
            }

            public void onChannelChanged(BaseChannel channel) {
                if (ChannelViewModel.this.isCurrentChannel(channel.getUrl())) {
                    ChannelViewModel.this.channel = (GroupChannel)channel;
                    ChannelViewModel.this.isChannelChanged.postValue((Object)true);
                }
            }

            public void onChannelDeleted(String channelUrl, BaseChannel.ChannelType channelType) {
                if (ChannelViewModel.this.isCurrentChannel(channelUrl)) {
                    ChannelViewModel.this.channelDeleted.postValue((Object)true);
                }
            }
        });
        this.requestChangeLogs((BaseChannel)this.channel);
        this.updateLastSeenAt();
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_PAUSE)
    private void onPause() {
        SendBird.removeConnectionHandler((String)CONNECTION_HANDLER_ID);
        SendBird.removeChannelHandler((String)CHANNEL_HANDLER_ID);
    }

    @Override
    public boolean hasMore() {
        return this.hasMore;
    }

    @Override
    public void loadMore() {
        this.load();
    }

    public void load() {
        this.worker.execute(() -> {
            try {
                int cacheMessageSize = this.messageCollection.size();
                long ts = cacheMessageSize > 0 ? this.messageCollection.first().getCreatedAt() : Long.MAX_VALUE;
                List<BaseMessage> newMessageList = this.loadPrevious(ts);
                this.hasMore = newMessageList.size() > 0;
                this.messageCollection.addAll(newMessageList);
                if (cacheMessageSize == 0) {
                    this.markAsRead();
                }
            }
            catch (Exception e) {
                Logger.w(e);
            }
            finally {
                this.notifyDataSetChanged();
            }
        });
    }

    private List<BaseMessage> loadPrevious(long ts) throws Exception {
        Logger.d(">> ChannelViewModel::loadPrevious()");
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference result = new AtomicReference();
        AtomicReference error = new AtomicReference();
        this.channel.getPreviousMessagesByTimestamp(ts, false, 40, true, BaseChannel.MessageTypeFilter.ALL, null, (messages, e) -> {
            try {
                if (e != null) {
                    error.set(e);
                    return;
                }
                result.set(messages);
            }
            finally {
                latch.countDown();
            }
        });
        latch.await();
        if (error.get() != null) {
            throw (Exception)error.get();
        }
        List newMessageList = (List)result.get();
        Logger.d("__ load previous result size : " + newMessageList.size());
        return newMessageList;
    }

    @Override
    protected void onCleared() {
        super.onCleared();
        this.worker.shutdownNow();
    }

    private void markAsRead() {
        Logger.d("markAsRead");
        this.channel.markAsRead();
    }

    private void notifyDataSetChanged() {
        List<BaseMessage> currentList = this.messageCollection.copyToList();
        currentList.addAll(0, PendingMessageRepository.getInstance().getPendingMessageList(this.channel.getUrl()));
        this.messageList.postValue(currentList);
    }

    private void requestChangeLogs(@NonNull BaseChannel channel) {
        String channelUrl = channel.getUrl();
        int cacheMessageSize = this.messageCollection.size();
        long lastSyncTs = cacheMessageSize > 0 ? this.messageCollection.last().getCreatedAt() : 0L;
        Logger.d("++ change logs channel url = %s, lastSyncTs = %s", channelUrl, lastSyncTs);
        if (lastSyncTs > 0L) {
            MessageChangeLogsPager pager = new MessageChangeLogsPager(channel, lastSyncTs);
            pager.load(new MessageChangeLogsPager.MessageChangeLogsResultHandler(){

                @Override
                public void onError(SendBirdException e) {
                    Logger.e(e);
                }

                @Override
                public void onResult(List<BaseMessage> added, List<BaseMessage> updated, List<Long> deletedIds) {
                    Logger.d("++ deleted message size : %s, before origin message size : %s, added message size : %s", deletedIds.size(), ChannelViewModel.this.messageCollection.size(), added.size());
                    for (long deletedId : deletedIds) {
                        BaseMessage deletedMessage = ChannelViewModel.this.messageCollection.get(deletedId);
                        if (deletedMessage == null) continue;
                        ChannelViewModel.this.messageCollection.remove(deletedMessage);
                    }
                    Logger.d("++ after deleted message size : %s", ChannelViewModel.this.messageCollection.size());
                    Logger.d("++ updatedMessage size : %s", updated.size());
                    ChannelViewModel.this.messageCollection.updateAll(updated);
                    if (added.size() > 0) {
                        ChannelViewModel.this.messageCollection.addAll(added);
                    }
                    Logger.d("++ after changeLogs messageList size : %s", ChannelViewModel.this.messageCollection.size());
                    boolean changed = added.size() > 0 || updated.size() > 0 || deletedIds.size() > 0;
                    Logger.d("++ changeLogs updated : %s", changed);
                    if (changed) {
                        ChannelViewModel.this.notifyDataSetChanged();
                        ChannelViewModel.this.markAsRead();
                    }
                }
            });
        }
    }

    public void setTyping(boolean isTyping) {
        if (isTyping) {
            this.channel.startTyping();
        } else {
            this.channel.endTyping();
        }
    }

    public void sendUserMessage(@NonNull String text) {
        String channelUrl = this.channel.getUrl();
        UserMessage pendingUserMessage = this.channel.sendUserMessage(text, (message, e) -> {
            if (e != null) {
                Logger.e(e);
                PendingMessageRepository.getInstance().updatePendingMessage(channelUrl, (BaseMessage)message);
                this.notifyDataSetChanged();
                return;
            }
            Logger.i("__ sent message : %s", message);
            this.messageCollection.add((BaseMessage)message);
            PendingMessageRepository.getInstance().removePendingMessage(channelUrl, (BaseMessage)message);
            this.notifyDataSetChanged();
        });
        PendingMessageRepository.getInstance().addPendingMessage(channelUrl, (BaseMessage)pendingUserMessage);
        this.notifyDataSetChanged();
    }

    public void sendFileMessage(final @NonNull Context context, final @NonNull Uri uri) {
        TaskQueue.addTask(new JobResultTask<FileInfo>(){

            @Override
            public FileInfo call() throws IOException {
                return FileUtils.getFileInfo(context.getApplicationContext(), uri);
            }

            @Override
            public void onResultForUiThread(FileInfo info, SendBirdException e) {
                if (e != null || info == null) {
                    Logger.w(e);
                    ChannelViewModel.this.provider.toastError(R.string.sb_text_error_send_message);
                    return;
                }
                Logger.i("\n\n%s\n\n", info);
                FileMessageParams params = info.toFileParams();
                String channelUrl = ChannelViewModel.this.channel.getUrl();
                FileMessage pendingFileMessage = ChannelViewModel.this.channel.sendFileMessage(params, (message, ee) -> {
                    if (ee != null) {
                        Logger.e(ee);
                        if (message != null) {
                            PendingMessageRepository.getInstance().updatePendingMessage(channelUrl, (BaseMessage)message);
                            ChannelViewModel.this.notifyDataSetChanged();
                        }
                        if (ee.getMessage() != null) {
                            ChannelViewModel.this.provider.toastError(R.string.sb_text_error_send_message);
                        }
                        return;
                    }
                    Logger.i("__ sent message : %s", message);
                    ChannelViewModel.this.messageCollection.add((BaseMessage)message);
                    PendingMessageRepository.getInstance().removePendingMessage(channelUrl, (BaseMessage)message);
                    ChannelViewModel.this.notifyDataSetChanged();
                });
                if (pendingFileMessage != null) {
                    PendingMessageRepository.getInstance().addFilePendingMessage(ChannelViewModel.this.channel.getUrl(), pendingFileMessage, info);
                    ChannelViewModel.this.notifyDataSetChanged();
                }
            }
        });
    }

    public void resendMessage(final @NonNull BaseMessage message) {
        final String channelUrl = this.channel.getUrl();
        if (message instanceof UserMessage) {
            UserMessage pendingMessage = this.channel.resendMessage((UserMessage)message, (message12, e) -> {
                if (e != null) {
                    Logger.e(e);
                    this.provider.toastError(R.string.sb_text_error_resend_message);
                    PendingMessageRepository.getInstance().updatePendingMessage(channelUrl, (BaseMessage)message12);
                    this.notifyDataSetChanged();
                    return;
                }
                Logger.i("__ sent message : %s", message12);
                this.messageCollection.add((BaseMessage)message12);
                PendingMessageRepository.getInstance().removePendingMessage(channelUrl, (BaseMessage)message12);
                this.notifyDataSetChanged();
            });
            PendingMessageRepository.getInstance().updatePendingMessage(channelUrl, (BaseMessage)pendingMessage);
            this.notifyDataSetChanged();
        } else if (message instanceof FileMessage) {
            TaskQueue.addTask(new JobResultTask<File>(){

                @Override
                public File call() {
                    FileInfo info = PendingMessageRepository.getInstance().getFailedUriFromMessage(message);
                    return info.getFile();
                }

                @Override
                public void onResultForUiThread(File file, SendBirdException e) {
                    FileMessage pendingMessage = ChannelViewModel.this.channel.resendMessage((FileMessage)message, file, (message1, e1) -> {
                        if (e1 != null) {
                            Logger.e(e1);
                            ChannelViewModel.this.provider.toastError(R.string.sb_text_error_resend_message);
                            PendingMessageRepository.getInstance().updatePendingMessage(channelUrl, (BaseMessage)message1);
                            ChannelViewModel.this.notifyDataSetChanged();
                            return;
                        }
                        Logger.i("__ sent message : %s", message1);
                        ChannelViewModel.this.messageCollection.add((BaseMessage)message1);
                        PendingMessageRepository.getInstance().removePendingMessage(channelUrl, (BaseMessage)message1);
                        ChannelViewModel.this.notifyDataSetChanged();
                    });
                    PendingMessageRepository.getInstance().updatePendingMessage(channelUrl, (BaseMessage)pendingMessage);
                    ChannelViewModel.this.notifyDataSetChanged();
                }
            });
        }
    }

    public void updateUserMessage(long messageId, @NonNull String text) {
        this.channel.updateUserMessage(messageId, text, null, null, (message, e) -> {
            if (e != null) {
                this.provider.toastError(R.string.sb_text_error_update_user_message);
                return;
            }
            Logger.d("++ edit message : %s", message);
            this.messageCollection.update((BaseMessage)message);
            this.notifyDataSetChanged();
        });
    }

    public void deleteMessage(@NonNull BaseMessage message) {
        if (message.getSendingStatus() == BaseMessage.SendingStatus.SUCCEEDED) {
            this.channel.deleteMessage(message, e -> {
                if (e != null) {
                    this.provider.toastError(R.string.sb_text_error_delete_message);
                    return;
                }
                Logger.d("++ delete message : %s", message);
                this.messageCollection.remove(message);
                this.notifyDataSetChanged();
            });
        } else {
            PendingMessageRepository.getInstance().removePendingMessage(message.getChannelUrl(), message);
            this.notifyDataSetChanged();
        }
    }

    private void updateLastSeenAt() {
        List members = this.channel.getMembers();
        if (members.size() == 2) {
            ReadStatus status = (ReadStatus)this.channel.getReadStatus(false).values().toArray()[0];
            this.lastSeenAt.postValue((Object)status.getTimestamp());
        }
    }

    public boolean downloadFile(final @NonNull Context context, final @NonNull FileMessage message, final @NonNull OnResultHandler<File> handler) {
        boolean isDownloading = FileDownloader.getInstance().isDownloading(message.getUrl());
        if (isDownloading) {
            return false;
        }
        TaskQueue.addTask(new JobResultTask<File>(){

            @Override
            public File call() throws ExecutionException, InterruptedException {
                return FileDownloader.getInstance().downloadToCache(context, message);
            }

            @Override
            public void onResultForUiThread(File file, SendBirdException e) {
                if (e != null) {
                    Logger.e(e);
                    handler.onError(e);
                    return;
                }
                handler.onResult(file);
            }
        });
        return true;
    }
}

