/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.model;

import androidx.annotation.NonNull;
import com.sendbird.android.BaseMessage;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.TimelineMessage;
import com.sendbird.uikit.utils.DateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

public class ChatMessageCollection {
    private static Comparator<BaseMessage> comparator = (o1, o2) -> {
        if (o1.getCreatedAt() > o2.getCreatedAt()) {
            return 1;
        }
        if (o1.equals(o2)) {
            return 0;
        }
        return -1;
    };
    private final TreeSet<BaseMessage> messageList = new TreeSet<BaseMessage>(comparator);

    private BaseMessage createTimeline(BaseMessage anchor) {
        return new TimelineMessage(anchor);
    }

    public synchronized void add(@NonNull BaseMessage message) {
        this.messageList.add(message);
    }

    public synchronized void addAll(@NonNull Collection<BaseMessage> messageList) {
        for (BaseMessage message : messageList) {
            this.add(message);
        }
    }

    public synchronized void removeByMessageId(long msgId) {
        if (this.messageList.size() > 0) {
            for (BaseMessage message : this.messageList) {
                if (message.getMessageId() != msgId) continue;
                Logger.d("++ deleteMessage : %s", message);
                this.remove(message);
                break;
            }
        }
    }

    public synchronized boolean remove(BaseMessage message) {
        if (message == null) {
            return false;
        }
        return this.messageList.remove(message);
    }

    public synchronized void update(@NonNull BaseMessage updatedMessage) {
        if (this.messageList.contains(updatedMessage)) {
            this.remove(updatedMessage);
            this.add(updatedMessage);
        }
    }

    public synchronized void updateAll(@NonNull List<BaseMessage> updated) {
        for (BaseMessage updatedMessage : updated) {
            this.update(updatedMessage);
        }
    }

    public boolean hasMessage() {
        return this.size() > 0;
    }

    public int size() {
        return this.messageList.size();
    }

    public BaseMessage get(long messageId) {
        for (BaseMessage message : this.messageList) {
            if (message.getMessageId() != messageId) continue;
            return message;
        }
        return null;
    }

    public BaseMessage last() {
        return this.messageList.last();
    }

    public BaseMessage first() {
        return this.messageList.first();
    }

    public synchronized List<BaseMessage> copyToList() {
        BaseMessage prevMessage = null;
        ArrayList<BaseMessage> copiedList = new ArrayList<BaseMessage>();
        for (BaseMessage message : this.messageList) {
            copiedList.add(0, message);
            if (prevMessage == null || !DateUtils.hasSameDate(message.getCreatedAt(), prevMessage.getCreatedAt())) {
                TimelineMessage timeline = new TimelineMessage(message);
                copiedList.add(1, timeline);
            }
            prevMessage = message;
        }
        return copiedList;
    }
}

