/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.databinding.DataBindingUtil;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.Member;
import com.sendbird.android.User;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.activities.ChannelActivity;
import com.sendbird.uikit.activities.adapter.UserListAdapter;
import com.sendbird.uikit.databinding.SbFragmentInviteChannelBinding;
import com.sendbird.uikit.fragments.BaseFragment;
import com.sendbird.uikit.interfaces.CustomUserListQueryHandler;
import com.sendbird.uikit.interfaces.UserInfo;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.ReadyStatus;
import com.sendbird.uikit.utils.TextUtils;
import com.sendbird.uikit.vm.UserListViewModel;
import com.sendbird.uikit.vm.ViewModelFactory;
import com.sendbird.uikit.widgets.StatusFrameView;
import java.util.HashSet;
import java.util.List;

public class InviteChannelFragment
extends BaseFragment {
    private SbFragmentInviteChannelBinding binding;
    private UserListViewModel viewModel;
    private UserListAdapter adapter;
    private View.OnClickListener headerLeftButtonListener;
    private CustomUserListQueryHandler customUserListQueryHandler;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        int themeResId = SendBirdUIKit.getDefaultThemeMode().getResId();
        if (args != null) {
            themeResId = args.getInt("KEY_THEME_RES_ID");
        }
        if (this.getActivity() != null) {
            this.getActivity().setTheme(themeResId);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.binding = (SbFragmentInviteChannelBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_fragment_invite_channel, (ViewGroup)container, (boolean)false);
        return this.binding.getRoot();
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.binding.statusFrame.setStatus(StatusFrameView.Status.LOADING);
        this.initHeaderOnCreated();
    }

    @Override
    public void onReady(User user, ReadyStatus status) {
        if (status == ReadyStatus.ERROR) {
            this.setErrorFrame();
            return;
        }
        Bundle args = this.getArguments();
        String channelUrl = null;
        if (args != null) {
            channelUrl = args.getString("KEY_CHANNEL_URL");
        }
        if (!TextUtils.isEmpty(channelUrl)) {
            GroupChannel.getChannel((String)channelUrl, (channel, e) -> {
                if (e != null) {
                    this.toastError(R.string.sb_text_error_get_channel);
                    Logger.e((Throwable)e);
                    return;
                }
                this.initPage(channel);
            });
        } else {
            this.toastError(R.string.sb_text_error_get_channel);
        }
    }

    private void setErrorFrame() {
        this.binding.statusFrame.setStatus(StatusFrameView.Status.CONNECTION_ERROR);
        this.binding.statusFrame.setOnActionEventListener(v -> {
            this.binding.statusFrame.setStatus(StatusFrameView.Status.LOADING);
            this.connect();
        });
    }

    private void initPage(GroupChannel channel) {
        this.viewModel = (UserListViewModel)new ViewModelProvider((ViewModelStoreOwner)this, (ViewModelProvider.Factory)new ViewModelFactory(this, this.customUserListQueryHandler)).get(UserListViewModel.class);
        this.initHeaderOnReady(channel);
        this.initUserList(channel);
    }

    private void initHeaderOnCreated() {
        Bundle args = this.getArguments();
        String headerTitle = this.getString(R.string.sb_text_header_invite_member);
        boolean useHeader = false;
        boolean useHeaderLeftButton = true;
        int headerLeftButtonIconResId = R.drawable.icon_arrow_left;
        if (args != null) {
            headerTitle = args.getString("KEY_HEADER_TITLE", this.getString(R.string.sb_text_header_invite_member));
            useHeader = args.getBoolean("KEY_USE_HEADER", false);
            useHeaderLeftButton = args.getBoolean("KEY_USE_HEADER_LEFT_BUTTON", true);
            headerLeftButtonIconResId = args.getInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", R.drawable.icon_arrow_left);
        }
        this.binding.abvInviteMember.setVisibility(useHeader ? 0 : 8);
        this.binding.abvInviteMember.getTitleTextView().setText((CharSequence)headerTitle);
        this.binding.abvInviteMember.getLeftImageButton().setVisibility(useHeaderLeftButton ? 0 : 8);
        this.binding.abvInviteMember.getLeftImageButton().setImageResource(headerLeftButtonIconResId);
        this.binding.abvInviteMember.getLeftImageButton().setOnClickListener(v -> {
            if (this.getActivity() != null) {
                this.getActivity().finish();
            }
        });
    }

    private void initHeaderOnReady(GroupChannel channel) {
        if (this.headerLeftButtonListener != null) {
            this.binding.abvInviteMember.getLeftImageButton().setOnClickListener(this.headerLeftButtonListener);
        }
        this.binding.abvInviteMember.getRightTextButton().setEnabled(false);
        this.binding.abvInviteMember.getRightTextButton().setOnClickListener(v -> this.viewModel.inviteMembers(channel, e -> {
            if (e != null) {
                this.toastError(R.string.sb_text_error_invite_member);
                Logger.e((Throwable)e);
                return;
            }
            if (this.isActive()) {
                Intent intent = new Intent(this.getContext(), ChannelActivity.class);
                intent.addFlags(0x4000000);
                this.startActivity(intent);
            }
        }));
        this.viewModel.getSelectedUserSet().observe((LifecycleOwner)this, selectedUsers -> {
            if (selectedUsers == null || selectedUsers.size() == 0) {
                this.binding.abvInviteMember.getRightTextButton().setEnabled(false);
                this.binding.abvInviteMember.getRightTextButton().setText(R.string.sb_text_button_invite);
            } else {
                this.binding.abvInviteMember.getRightTextButton().setEnabled(true);
                this.binding.abvInviteMember.getRightTextButton().setText((CharSequence)String.format(this.getString(R.string.sb_text_button_invite_with_count), selectedUsers.size()));
            }
        });
    }

    private void initUserList(GroupChannel channel) {
        if (this.adapter == null) {
            this.adapter = new UserListAdapter();
        }
        HashSet<String> invitedMemberSet = new HashSet<String>();
        for (Member member : channel.getMembers()) {
            invitedMemberSet.add(member.getUserId());
        }
        this.viewModel.setInvitedUser(invitedMemberSet);
        this.adapter.setUserListViewModel(this.viewModel);
        this.binding.rvInviteUserList.setAdapter(this.adapter);
        this.binding.rvInviteUserList.setHasFixedSize(true);
        this.binding.rvInviteUserList.setPager(this.viewModel);
        this.binding.rvInviteUserList.setThreshold(5);
        this.viewModel.getStatusFrame().observe((LifecycleOwner)this, this.binding.statusFrame::setStatus);
        this.viewModel.getUserList().observe((LifecycleOwner)this, users -> {
            Logger.d("++ observing result users size : %s", users.size());
            this.binding.rvInviteUserList.setRefreshing(false);
            this.adapter.setItems((List<UserInfo>)users);
        });
    }

    private void setUserListAdapter(UserListAdapter adapter) {
        this.adapter = adapter;
    }

    private void setHeaderLeftButtonListener(View.OnClickListener listener) {
        this.headerLeftButtonListener = listener;
    }

    private void setCustomUserListQueryHandler(CustomUserListQueryHandler handler) {
        this.customUserListQueryHandler = handler;
    }

    public static class Builder {
        private Bundle bundle = new Bundle();
        private CustomUserListQueryHandler customUserListQueryHandler = null;
        private UserListAdapter adapter;
        private View.OnClickListener headerLeftButtonListener;

        public Builder(@NonNull String channelUrl) {
            this(channelUrl, SendBirdUIKit.getDefaultThemeMode());
        }

        public Builder(@NonNull String channelUrl, SendBirdUIKit.ThemeMode themeMode) {
            this.bundle.putInt("KEY_THEME_RES_ID", themeMode.getResId());
            this.bundle.putString("KEY_CHANNEL_URL", channelUrl);
        }

        public Builder(@NonNull String channelUrl, @StyleRes int customThemeResId) {
            this.bundle.putInt("KEY_THEME_RES_ID", customThemeResId);
            this.bundle.putString("KEY_CHANNEL_URL", channelUrl);
        }

        public Builder setHeaderTitle(String title) {
            this.bundle.putString("KEY_HEADER_TITLE", title);
            return this;
        }

        public Builder setUseHeader(boolean useHeader) {
            this.bundle.putBoolean("KEY_USE_HEADER", useHeader);
            return this;
        }

        public Builder setUseHeaderLeftButton(boolean useHeaderLeftButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_LEFT_BUTTON", useHeaderLeftButton);
            return this;
        }

        public Builder setHeaderLeftButtonIconResId(@DrawableRes int resId) {
            this.bundle.putInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", resId);
            return this;
        }

        public Builder setCustomUserListQueryHandler(CustomUserListQueryHandler handler) {
            this.customUserListQueryHandler = handler;
            return this;
        }

        public Builder setUserListAdapter(UserListAdapter adapter) {
            this.adapter = adapter;
            return this;
        }

        public Builder setHeaderLeftButtonListener(View.OnClickListener listener) {
            this.headerLeftButtonListener = listener;
            return this;
        }

        public InviteChannelFragment build() {
            InviteChannelFragment fragment = new InviteChannelFragment();
            fragment.setArguments(this.bundle);
            fragment.setCustomUserListQueryHandler(this.customUserListQueryHandler);
            fragment.setUserListAdapter(this.adapter);
            fragment.setHeaderLeftButtonListener(this.headerLeftButtonListener);
            return fragment;
        }
    }
}

