/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.databinding.DataBindingUtil;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.sendbird.android.User;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.activities.ChannelActivity;
import com.sendbird.uikit.activities.adapter.UserListAdapter;
import com.sendbird.uikit.databinding.SbFragmentCreateChannelBinding;
import com.sendbird.uikit.fragments.BaseFragment;
import com.sendbird.uikit.interfaces.CustomUserListQueryHandler;
import com.sendbird.uikit.interfaces.UserInfo;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.ReadyStatus;
import com.sendbird.uikit.vm.UserListViewModel;
import com.sendbird.uikit.vm.ViewModelFactory;
import com.sendbird.uikit.widgets.StatusFrameView;
import java.util.List;

public class CreateChannelFragment
extends BaseFragment {
    private SbFragmentCreateChannelBinding binding;
    private UserListViewModel viewModel;
    private UserListAdapter adapter;
    private boolean isDistinct = false;
    private View.OnClickListener headerLeftButtonListener;
    private CustomUserListQueryHandler customUserListQueryHandler;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        int themeResId = SendBirdUIKit.getDefaultThemeMode().getResId();
        if (args != null) {
            themeResId = args.getInt("KEY_THEME_RES_ID");
        }
        if (this.getActivity() != null) {
            this.getActivity().setTheme(themeResId);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.binding = (SbFragmentCreateChannelBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_fragment_create_channel, (ViewGroup)container, (boolean)false);
        return this.binding.getRoot();
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.binding.statusFrame.setStatus(StatusFrameView.Status.LOADING);
        this.initHeaderOnCreated();
    }

    @Override
    public void onReady(User user, ReadyStatus status) {
        Logger.d(">> CreateGroupChannelActivity::onReady()");
        if (status == ReadyStatus.ERROR) {
            this.setErrorFrame();
        } else {
            this.initPage();
        }
    }

    private void setErrorFrame() {
        this.binding.statusFrame.setStatus(StatusFrameView.Status.CONNECTION_ERROR);
        this.binding.statusFrame.setOnActionEventListener(v -> {
            this.binding.statusFrame.setStatus(StatusFrameView.Status.LOADING);
            this.connect();
        });
    }

    private void initPage() {
        this.viewModel = (UserListViewModel)new ViewModelProvider((ViewModelStoreOwner)this, (ViewModelProvider.Factory)new ViewModelFactory(this, this.customUserListQueryHandler)).get(UserListViewModel.class);
        this.initHeaderOnReady();
        this.initUserList();
    }

    private void initHeaderOnCreated() {
        Bundle args = this.getArguments();
        String headerTitle = this.getString(R.string.sb_text_header_create_channel);
        boolean useHeader = false;
        boolean useHeaderLeftButton = true;
        int headerLeftButtonIconResId = R.drawable.icon_arrow_left;
        if (args != null) {
            headerTitle = args.getString("KEY_HEADER_TITLE", this.getString(R.string.sb_text_header_create_channel));
            useHeader = args.getBoolean("KEY_USE_HEADER", false);
            useHeaderLeftButton = args.getBoolean("KEY_USE_HEADER_LEFT_BUTTON", true);
            headerLeftButtonIconResId = args.getInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", R.drawable.icon_arrow_left);
        }
        this.binding.abvCreateGroupChannel.setVisibility(useHeader ? 0 : 8);
        this.binding.abvCreateGroupChannel.getTitleTextView().setText((CharSequence)headerTitle);
        this.binding.abvCreateGroupChannel.getLeftImageButton().setVisibility(useHeaderLeftButton ? 0 : 8);
        this.binding.abvCreateGroupChannel.getLeftImageButton().setImageResource(headerLeftButtonIconResId);
        this.binding.abvCreateGroupChannel.getLeftImageButton().setOnClickListener(v -> {
            if (this.getActivity() != null) {
                this.getActivity().finish();
            }
        });
    }

    private void initHeaderOnReady() {
        Bundle args;
        if (this.headerLeftButtonListener != null) {
            this.binding.abvCreateGroupChannel.getLeftImageButton().setOnClickListener(this.headerLeftButtonListener);
        }
        if ((args = this.getArguments()) != null) {
            this.isDistinct = args.getBoolean("KEY_DISTINCT", false);
        }
        this.binding.abvCreateGroupChannel.getRightTextButton().setEnabled(false);
        this.binding.abvCreateGroupChannel.getRightTextButton().setOnClickListener(v -> this.viewModel.createGroupChannel((groupChannel, ex) -> {
            if (ex != null) {
                this.toastError(R.string.sb_text_error_create_channel);
                Logger.e((Throwable)ex);
                return;
            }
            if (this.isActive()) {
                this.startActivity(ChannelActivity.newIntent(this.getContext(), groupChannel.getUrl()));
                this.getActivity().finish();
            }
        }, this.isDistinct));
        this.viewModel.getSelectedUserSet().observe((LifecycleOwner)this, selectedUsers -> {
            if (selectedUsers == null || selectedUsers.size() == 0) {
                this.binding.abvCreateGroupChannel.getRightTextButton().setEnabled(false);
                this.binding.abvCreateGroupChannel.getRightTextButton().setText(R.string.sb_text_button_create);
            } else {
                this.binding.abvCreateGroupChannel.getRightTextButton().setEnabled(true);
                this.binding.abvCreateGroupChannel.getRightTextButton().setText((CharSequence)String.format(this.getString(R.string.sb_text_button_create_with_count), selectedUsers.size()));
            }
        });
    }

    private void initUserList() {
        if (this.adapter == null) {
            this.adapter = new UserListAdapter();
        }
        this.adapter.setUserListViewModel(this.viewModel);
        this.binding.rvUserList.setAdapter(this.adapter);
        this.binding.rvUserList.setHasFixedSize(true);
        this.binding.rvUserList.setPager(this.viewModel);
        this.binding.rvUserList.setThreshold(5);
        this.viewModel.getStatusFrame().observe((LifecycleOwner)this, this.binding.statusFrame::setStatus);
        this.viewModel.getUserList().observe((LifecycleOwner)this, users -> {
            Logger.d("++ observing result users size : %s", users.size());
            this.binding.rvUserList.setRefreshing(false);
            this.adapter.setItems((List<UserInfo>)users);
        });
    }

    private void setCustomUserListQueryHandler(CustomUserListQueryHandler handler) {
        this.customUserListQueryHandler = handler;
    }

    private void setUserListAdapter(UserListAdapter adapter) {
        this.adapter = adapter;
    }

    private void setHeaderLeftButtonListener(View.OnClickListener listener) {
        this.headerLeftButtonListener = listener;
    }

    public static class Builder {
        private Bundle bundle = new Bundle();
        private CustomUserListQueryHandler customUserListQueryHandler = null;
        private UserListAdapter adapter;
        private View.OnClickListener headerLeftButtonListener;

        public Builder() {
            this(SendBirdUIKit.getDefaultThemeMode());
        }

        public Builder(SendBirdUIKit.ThemeMode themeMode) {
            this.bundle.putInt("KEY_THEME_RES_ID", themeMode.getResId());
        }

        public Builder(@StyleRes int customThemeResId) {
            this.bundle.putInt("KEY_THEME_RES_ID", customThemeResId);
        }

        public Builder setCustomUserListQueryHandler(CustomUserListQueryHandler handler) {
            this.customUserListQueryHandler = handler;
            return this;
        }

        public Builder setHeaderTitle(String title) {
            this.bundle.putString("KEY_HEADER_TITLE", title);
            return this;
        }

        public Builder setUseHeader(boolean useHeader) {
            this.bundle.putBoolean("KEY_USE_HEADER", useHeader);
            return this;
        }

        public Builder setUseHeaderLeftButton(boolean useHeaderLeftButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_LEFT_BUTTON", useHeaderLeftButton);
            return this;
        }

        public Builder setHeaderLeftButtonIconResId(@DrawableRes int resId) {
            this.bundle.putInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", resId);
            return this;
        }

        public Builder setIsDistinct(boolean isDistinct) {
            this.bundle.putBoolean("KEY_DISTINCT", isDistinct);
            return this;
        }

        public Builder setUserListAdapter(UserListAdapter adapter) {
            this.adapter = adapter;
            return this;
        }

        public Builder setHeaderLeftButtonListener(View.OnClickListener listener) {
            this.headerLeftButtonListener = listener;
            return this;
        }

        public CreateChannelFragment build() {
            CreateChannelFragment fragment = new CreateChannelFragment();
            fragment.setArguments(this.bundle);
            fragment.setCustomUserListQueryHandler(this.customUserListQueryHandler);
            fragment.setUserListAdapter(this.adapter);
            fragment.setHeaderLeftButtonListener(this.headerLeftButtonListener);
            return fragment;
        }
    }
}

