/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.activities.viewholder;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.ViewDataBinding;
import androidx.recyclerview.widget.RecyclerView;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.uikit.utils.DateUtils;
import com.sendbird.uikit.utils.MessageUtils;

public abstract class MessageViewHolder
extends RecyclerView.ViewHolder {
    protected ViewDataBinding binding;
    private boolean isNewDate = false;
    private boolean isMine = false;
    private boolean isShowProfile = false;

    public MessageViewHolder(View view) {
        super(view);
    }

    MessageViewHolder(@NonNull ViewDataBinding binding) {
        super(binding.getRoot());
        this.binding = binding;
    }

    public void onBindViewHolder(BaseChannel channel, @Nullable BaseMessage prevMessage, @NonNull BaseMessage message, @Nullable BaseMessage nextMessage) {
        this.isNewDate = prevMessage != null ? !DateUtils.hasSameDate(message.getCreatedAt(), prevMessage.getCreatedAt()) : true;
        this.isMine = MessageUtils.isMine(message);
        this.isShowProfile = !this.isMine;
        this.bind(channel, message);
        if (this.binding != null) {
            this.binding.executePendingBindings();
        }
    }

    protected boolean isNewDate() {
        return this.isNewDate;
    }

    protected boolean isShowProfile() {
        return this.isShowProfile;
    }

    protected boolean isMine() {
        return this.isMine;
    }

    public abstract void bind(BaseChannel var1, @NonNull BaseMessage var2);

    public abstract View getClickableView();
}

