/*
 * Decompiled with CFR 0.152.
 */
package com.segment.analytics.android.integrations.mixpanel;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import com.segment.analytics.Analytics;
import com.segment.analytics.Properties;
import com.segment.analytics.Traits;
import com.segment.analytics.ValueMap;
import com.segment.analytics.integrations.AliasPayload;
import com.segment.analytics.integrations.IdentifyPayload;
import com.segment.analytics.integrations.Integration;
import com.segment.analytics.integrations.Logger;
import com.segment.analytics.integrations.ScreenPayload;
import com.segment.analytics.integrations.TrackPayload;
import com.segment.analytics.internal.Utils;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class MixpanelIntegration
extends Integration<MixpanelAPI> {
    private static final String VIEWED_EVENT_FORMAT = "Viewed %s Screen";
    public static final Integration.Factory FACTORY = new Integration.Factory(){

        public Integration<?> create(ValueMap settings, Analytics analytics) {
            boolean consolidatedPageCalls = settings.getBoolean("consolidatedPageCalls", true);
            boolean trackAllPages = settings.getBoolean("trackAllPages", false);
            boolean trackCategorizedPages = settings.getBoolean("trackCategorizedPages", false);
            boolean trackNamedPages = settings.getBoolean("trackNamedPages", false);
            boolean isPeopleEnabled = settings.getBoolean("people", false);
            String token = settings.getString("token");
            Set increments = MixpanelIntegration.getStringSet(settings, "increments");
            boolean setAllTraitsByDefault = settings.getBoolean("setAllTraitsByDefault", true);
            Set peopleProperties = MixpanelIntegration.getStringSet(settings, "peopleProperties");
            Set superProperties = MixpanelIntegration.getStringSet(settings, "superProperties");
            Logger logger = analytics.logger(MixpanelIntegration.MIXPANEL_KEY);
            MixpanelAPI mixpanel = MixpanelAPI.getInstance((Context)analytics.getApplication(), (String)token);
            logger.verbose("MixpanelAPI.getInstance(context, %s);", new Object[]{token});
            MixpanelAPI.People people = isPeopleEnabled ? mixpanel.getPeople() : null;
            return new MixpanelIntegration(mixpanel, people, isPeopleEnabled, consolidatedPageCalls, trackAllPages, trackCategorizedPages, trackNamedPages, token, logger, increments, setAllTraitsByDefault, peopleProperties, superProperties);
        }

        public String key() {
            return MixpanelIntegration.MIXPANEL_KEY;
        }
    };
    private static final String MIXPANEL_KEY = "Mixpanel";
    private static final Map<String, String> MAPPER;
    private final MixpanelAPI mixpanel;
    final MixpanelAPI.People mixpanelPeople;
    final boolean isPeopleEnabled;
    private final boolean consolidatedPageCalls;
    final boolean trackAllPages;
    final boolean trackCategorizedPages;
    final boolean trackNamedPages;
    final String token;
    private final Logger logger;
    final Set<String> increments;
    final boolean setAllTraitsByDefault;
    private final Set<String> peopleProperties;
    private final Set<String> superProperties;

    private static Set<String> getStringSet(ValueMap valueMap, String key) {
        try {
            List incrementEvents = (List)valueMap.get((Object)key);
            if (incrementEvents == null || incrementEvents.size() == 0) {
                return Collections.emptySet();
            }
            HashSet<String> stringSet = new HashSet<String>(incrementEvents.size());
            for (int i = 0; i < incrementEvents.size(); ++i) {
                stringSet.add((String)incrementEvents.get(i));
            }
            return stringSet;
        }
        catch (ClassCastException e) {
            return Collections.emptySet();
        }
    }

    public MixpanelIntegration(MixpanelAPI mixpanel, MixpanelAPI.People mixpanelPeople, boolean isPeopleEnabled, boolean consolidatedPageCalls, boolean trackAllPages, boolean trackCategorizedPages, boolean trackNamedPages, String token, Logger logger, Set<String> increments, boolean setAllTraitsByDefault, Set<String> peopleProperties, Set<String> superProperties) {
        this.mixpanel = mixpanel;
        this.mixpanelPeople = mixpanelPeople;
        this.isPeopleEnabled = isPeopleEnabled;
        this.consolidatedPageCalls = consolidatedPageCalls;
        this.trackAllPages = trackAllPages;
        this.trackCategorizedPages = trackCategorizedPages;
        this.trackNamedPages = trackNamedPages;
        this.token = token;
        this.logger = logger;
        this.increments = increments;
        this.setAllTraitsByDefault = setAllTraitsByDefault;
        this.peopleProperties = peopleProperties;
        this.superProperties = superProperties;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        super.onActivityCreated(activity, savedInstanceState);
        MixpanelAPI.getInstance((Context)activity, (String)this.token);
    }

    public MixpanelAPI getUnderlyingInstance() {
        return this.mixpanel;
    }

    private void registerSuperProperties(Map<String, Object> in) {
        if (Utils.isNullOrEmpty(in)) {
            return;
        }
        JSONObject superProperties = new ValueMap(Utils.transform(in, MAPPER)).toJsonObject();
        this.mixpanel.registerSuperProperties(superProperties);
        this.logger.verbose("mixpanel.registerSuperProperties(%s)", new Object[]{superProperties});
    }

    private void setPeopleProperties(Map<String, Object> in) {
        if (Utils.isNullOrEmpty(in)) {
            return;
        }
        if (!this.isPeopleEnabled) {
            return;
        }
        JSONObject peopleProperties = new ValueMap(Utils.transform(in, MAPPER)).toJsonObject();
        this.mixpanelPeople.set(peopleProperties);
        this.logger.verbose("mixpanel.getPeople().set(%s)", new Object[]{peopleProperties});
    }

    static <T> Map<String, T> filter(Map<String, T> in, Iterable<String> filter) {
        LinkedHashMap<String, T> out = new LinkedHashMap<String, T>();
        for (String field : filter) {
            if (!in.containsKey(field)) continue;
            out.put(field, in.get(field));
        }
        return out;
    }

    public void identify(IdentifyPayload identify) {
        super.identify(identify);
        String userId = identify.userId();
        if (userId != null) {
            this.mixpanel.identify(userId);
            this.logger.verbose("mixpanel.identify(%s)", new Object[]{userId});
            if (this.isPeopleEnabled) {
                this.mixpanelPeople.identify(userId);
                this.logger.verbose("mixpanel.getPeople().identify(%s)", new Object[]{userId});
            }
        }
        Traits traits = identify.traits();
        if (this.setAllTraitsByDefault) {
            this.registerSuperProperties((Map<String, Object>)traits);
            this.setPeopleProperties((Map<String, Object>)traits);
            return;
        }
        Map<String, Object> superPropertyTraits = MixpanelIntegration.filter(traits, this.superProperties);
        this.registerSuperProperties(superPropertyTraits);
        Map<String, Object> peoplePropertyTraits = MixpanelIntegration.filter(traits, this.peopleProperties);
        this.setPeopleProperties(peoplePropertyTraits);
    }

    public void flush() {
        super.flush();
        this.mixpanel.flush();
        this.logger.verbose("mixpanel.flush()", new Object[0]);
    }

    public void reset() {
        super.reset();
        this.mixpanel.reset();
        this.logger.verbose("mixpanel.reset()", new Object[0]);
    }

    public void alias(AliasPayload alias) {
        String userId;
        super.alias(alias);
        String previousId = alias.previousId();
        if (previousId.equals(alias.anonymousId())) {
            previousId = this.mixpanel.getDistinctId();
        }
        if ((userId = alias.userId()) != null) {
            this.mixpanel.alias(userId, previousId);
            this.logger.verbose("mixpanel.alias(%s, %s)", new Object[]{userId, previousId});
        }
    }

    public void screen(ScreenPayload screen) {
        if (this.consolidatedPageCalls) {
            Properties properties = new Properties();
            properties.putAll((Map)screen.properties());
            properties.put("name", (Object)screen.name());
            this.event("Loaded a Screen", properties);
            return;
        }
        if (this.trackAllPages) {
            this.event(String.format(VIEWED_EVENT_FORMAT, screen.event()), screen.properties());
        } else if (this.trackCategorizedPages && !Utils.isNullOrEmpty((CharSequence)screen.category())) {
            this.event(String.format(VIEWED_EVENT_FORMAT, screen.category()), screen.properties());
        } else if (this.trackNamedPages && !Utils.isNullOrEmpty((CharSequence)screen.name())) {
            this.event(String.format(VIEWED_EVENT_FORMAT, screen.name()), screen.properties());
        }
    }

    public void track(TrackPayload track) {
        String event = track.event();
        this.event(event, track.properties());
        if (this.increments.contains(event) && this.isPeopleEnabled) {
            this.mixpanelPeople.increment(event, 1.0);
            this.mixpanelPeople.set("Last " + event, (Object)new Date());
        }
    }

    void event(String name, Properties properties) {
        JSONObject props = properties.toJsonObject();
        this.mixpanel.track(name, props);
        this.logger.verbose("mixpanel.track(%s, %s)", new Object[]{name, props});
        if (!this.isPeopleEnabled) {
            return;
        }
        double revenue = properties.revenue();
        if (revenue == 0.0) {
            return;
        }
        this.mixpanelPeople.trackCharge(revenue, props);
        this.logger.verbose("mixpanelPeople.trackCharge(%s, %s)", new Object[]{revenue, props});
    }

    static {
        LinkedHashMap<String, String> mapper = new LinkedHashMap<String, String>();
        mapper.put("email", "$email");
        mapper.put("phone", "$phone");
        mapper.put("firstName", "$first_name");
        mapper.put("lastName", "$last_name");
        mapper.put("name", "$name");
        mapper.put("username", "$username");
        mapper.put("createdAt", "$created");
        MAPPER = Collections.unmodifiableMap(mapper);
    }
}

