package com.seeq.link.sdk.utilities;

import java.time.Duration;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

import com.google.common.base.Stopwatch;
import com.seeq.link.sdk.interfaces.Connection;
import com.seeq.link.sdk.interfaces.Connection.ConnectionState;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class StateChangeAccumulator {

    public Duration timeout = Duration.ofSeconds(50);

    public StateChangeAccumulator() {

    }

    public StateChangeAccumulator(Duration timeout) {
        this.timeout = timeout;
    }

    public boolean confirmStateChange(ConnectionState requiredState) {
        Stopwatch generalTimeout = Stopwatch.createStarted();
        while (true) {
            if (this.stateChangeQueue.isEmpty()) {
                if (generalTimeout.elapsed(TimeUnit.SECONDS) > this.timeout.getSeconds()) {
                    LOG.error("Timed out waiting for state change to '{}'", requiredState);
                    return false;
                }

                try {
                    Thread.sleep(100);
                } catch (InterruptedException e) {
                    return false;
                }
                continue;
            }

            ConnectionState newState = this.stateChangeQueue.poll();

            if (requiredState == newState) {
                return true;
            } else {
                String remainingInQueue = "";
                if (this.stateChangeQueue.peek() != null) {
                    remainingInQueue = "[Next state change(s) detected:";
                    while (true) {
                        ConnectionState remaining = this.stateChangeQueue.poll();
                        if (remaining == null) {
                            break;
                        }
                        remainingInQueue += String.format(" '%s'", remaining.toString());
                    }
                    remainingInQueue += "]";
                }
                LOG.error("State change mismatch. Expected '{}', instead was '{}'. {}", requiredState, newState,
                        remainingInQueue);
                return false;
            }
        }
    }

    private final Queue<ConnectionState> stateChangeQueue = new LinkedList<>();

    public void stateChanged(Connection sender, ConnectionState state, String message) {
        this.stateChangeQueue.add(state);
    }
}
