


package com.seeq.link.sdk.utilities;

import java.util.Map;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.seeq.ApiException;

public final class SeeqSDKHelper {

    private SeeqSDKHelper() {}

    /**
     * Returns a String representation of the ApiException suitable for printing/logging.
     *
     * @param e
     *         the ApiException to format
     * @return a loggable message String
     */
    public static String formatApiException(ApiException e) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            @SuppressWarnings("unchecked")
            Map<String, String> body = mapper.readValue(e.getResponseBody(), Map.class);
            return String.format("(%s) %s", e.getCode(), body.get("statusMessage")).trim();
        } catch (Exception e1) {
            return String.format("(%s) %s", e.getCode(), e.getMessage()).trim();
        }
    }
}
