package com.seeq.link.sdk.utilities;

import java.util.function.Supplier;

import com.seeq.ApiClient;

import lombok.Getter;
import lombok.Setter;

public class SeeqApiRequestHelper<T> {

    @Getter
    @Setter
    public Supplier<ApiClient.ApiResponse<T>> request;

    public SeeqSdkApiResponse<T> makeRequest() {
        ApiClient.ApiResponse<T> apiResponse = this.request.get();
        return new SeeqSdkApiResponse<T>(apiResponse.getHeaders(), apiResponse.getData());
    }
}
