package com.seeq.link.sdk.utilities;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Represents a sample data point from a signal, with a key (time) and value (number or string).
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class Sample {
    /**
     * The key of the sample
     */
    private TimeInstant key;
    /**
     * The value of the sample
     */
    private Object value;

    /**
     * Set the key of the sample
     *
     * @param key
     *         the new key
     * @return the Sample, so multiple setters can be chained
     */
    public Sample key(TimeInstant key) {
        this.key = key;
        return this;
    }

    /**
     * Set the value of the sample
     *
     * @param value
     *         the new value
     * @return the Sample, so multiple setters can be chained
     */
    public Sample value(Object value) {
        this.value = value;
        return this;
    }

    // explicit function for visibility in Kotlin
    public TimeInstant getKey() {return this.key;}
}
