package com.seeq.link.sdk.utilities;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.seeq.utilities.SeeqNames;

import lombok.Data;

@Data
public class RequestTimings {
    public Duration datasourceDuration;
    public int datasourceSamplesCount;
    public int datasourceCapsulesCount;
    public Duration cacheDuration;
    public int cachePersistedSamplesCount;
    public int cachePersistedCapsulesCount;
    public int cacheInMemorySamplesCount;
    public int cacheInMemoryCapsulesCount;
    public Duration calcEngineProcessingDuration;
    public Duration calcEngineQueueDuration;
    public Duration requestQueueDuration;
    public Duration garbageCollectionDuration;
    public Duration metadataDuration;
    public int metadataItemsCount;
    public int metadataRelationshipsCount;

    private static Duration fromMillisecondsString(String milliseconds) {
        return Duration.of((long) (Float.parseFloat(milliseconds) * 1000), ChronoUnit.MICROS);
    }

    public static RequestTimings fromApiResponseHeaders(Map<String, List<String>> headers) {
        HashMap<String, String> pieces = new HashMap<>();
        for (String header : new String[] { headers.get(SeeqNames.API.Headers.ServerTiming).get(0),
                headers.get(SeeqNames.API.Headers.ServerMeters).get(0) }) {
            for (String tuple : header.split(",")) {
                HashMap<String, String> parts = new HashMap<>();
                for (String part : tuple.split(";")) {
                    if (part.indexOf('=') == -1) {
                        continue;
                    }
                    String key = part.substring(0, part.indexOf('='));
                    String value = part.substring(part.indexOf('=') + 1);
                    parts.put(key, value);
                }

                pieces.put(parts.get("desc").replace("\"", ""), parts.get("dur"));
            }
        }

        RequestTimings requestTimings = new RequestTimings();
        requestTimings
                .setDatasourceDuration(fromMillisecondsString(pieces.get(SeeqNames.API.Headers.Timings.Datasource)));
        requestTimings.setDatasourceSamplesCount(
                (int) Float.parseFloat(pieces.get(SeeqNames.API.Headers.Meters.DatasourceSamplesRead)));
        requestTimings.setDatasourceCapsulesCount(
                (int) Float.parseFloat(pieces.get(SeeqNames.API.Headers.Meters.DatasourceCapsulesRead)));
        requestTimings.setCacheDuration(fromMillisecondsString(pieces.get(SeeqNames.API.Headers.Timings.Cache)));
        requestTimings.setCachePersistedSamplesCount(
                (int) Float.parseFloat(pieces.get(SeeqNames.API.Headers.Meters.CacheSamplesRead)));
        requestTimings.setCachePersistedCapsulesCount(
                (int) Float.parseFloat(pieces.get(SeeqNames.API.Headers.Meters.CacheCapsulesRead)));
        requestTimings.setCacheInMemorySamplesCount(
                (int) Float.parseFloat(pieces.get(SeeqNames.API.Headers.Meters.CacheInMemorySamplesRead)));
        requestTimings.setCacheInMemoryCapsulesCount(
                (int) Float.parseFloat(pieces.get(SeeqNames.API.Headers.Meters.CacheInMemoryCapsulesRead)));
        requestTimings.setCalcEngineProcessingDuration(
                fromMillisecondsString(pieces.get(SeeqNames.API.Headers.Timings.Processing)));
        requestTimings.setCalcEngineQueueDuration(
                fromMillisecondsString(pieces.get(SeeqNames.API.Headers.Timings.CalcEngineQueue)));
        requestTimings.setRequestQueueDuration(
                fromMillisecondsString(pieces.get(SeeqNames.API.Headers.Timings.RequestQueue)));
        requestTimings
                .setGarbageCollectionDuration(fromMillisecondsString(pieces.get(SeeqNames.API.Headers.Timings.GC)));
        requestTimings
                .setMetadataDuration(fromMillisecondsString(pieces.get(SeeqNames.API.Headers.Timings.SeeqDatabase)));
        requestTimings.setMetadataItemsCount(
                (int) Float.parseFloat(pieces.get(SeeqNames.API.Headers.Meters.DatabaseItemsRead)));
        requestTimings.setMetadataRelationshipsCount(
                (int) Float.parseFloat(pieces.get(SeeqNames.API.Headers.Meters.DatabaseRelationshipsRead)));
        return requestTimings;
    }
}
