package com.seeq.link.sdk.utilities;

import com.seeq.utilities.exception.OperationCanceledException;

public class RequestCancellation {
    /**
     * Checks if this thread has been interrupted, and throws an {@link OperationCanceledException} if so.
     * This is necessary anywhere we want to check for cancellation where no blocking methods are called. Methods such
     * as Thread.Sleep that throw an InterruptedException will check, but in other situations explicitly checking is
     * necessary.
     */
    public static void check() {
        if (Thread.interrupted()) {
            throw new OperationCanceledException("Request canceled");
        }
    }
}
