package com.seeq.link.sdk.utilities;

public class FormulaHelper {
    /**
     * Convert a plain string into a formula that represents a string scalar.
     *
     * @param input
     *         A plain string.
     * @return A formula string that will evaluate to the input string.
     */
    public static String escapeStringAsFormula(String input) {
        return "\"" + input
                .replace("\\", "\\\\")
                .replace("\n", "\\n")
                .replace("\r", "\\r")
                .replace("\"", "\\\"") +
                "\"";
    }
}
