package com.seeq.link.sdk.utilities;

public final class ExceptionHelper {
    private ExceptionHelper() {}

    /**
     * Transforms an exception object into a String that may be displayed to the user.
     *
     * @param throwable
     *         The exception object ({@link Throwable} subclass)
     * @return The exception message
     */
    public static String toExceptionMessage(Throwable throwable) {
        return throwable.getClass().getSimpleName() + ": " + throwable.getMessage();
    }
}
