package com.seeq.link.sdk.utilities;

import java.util.Arrays;

/**
 * From http://www.redirecttonull.com/?p=13
 *
 * @param <M>
 *         a class to encapsulate the message payload of the event
 */
public class Event<M> {

    public static class ListenerRegistration {

        private final Event<?> event;
        private final EventListener<?> listener;
        private boolean unregistered;

        private <M> ListenerRegistration(final Event<M> event, final EventListener<M> listener) {
            this.event = event;
            this.listener = listener;
        }

        public void remove() {
            if (!this.unregistered) {
                this.unregistered = true;
                this.event.remove(this.listener);
            }
        }

        public boolean isSubscribed() {
            return !this.unregistered;
        }
    }

    private Object[] listeners;

    public ListenerRegistration add(final EventListener<M> listener) {
        synchronized (this) {
            if (this.listeners == null) {
                this.listeners = new Object[] { listener };
            } else {
                this.listeners = Arrays.copyOf(this.listeners, this.listeners.length + 1);
                this.listeners[this.listeners.length - 1] = listener;
            }
        }
        return new ListenerRegistration(this, listener);
    }

    @SuppressWarnings("unchecked")
    public void dispatch(final Object source, final M message) {
        final Object[] local = this.listeners;
        if (local != null) {
            for (final Object listener : local) {
                ((EventListener<M>) listener).onNotify(source, message);
            }
        }
    }

    public void remove(final EventListener<?> listener) {
        synchronized (this) {
            if (this.listeners.length > 1) {
                final Object[] newObservers = new Object[this.listeners.length - 1];
                for (int i = 0, j = 0; i < this.listeners.length; i++) {
                    if (!this.listeners[i].equals(listener)) {
                        newObservers[j++] = this.listeners[i];
                    }
                }
                this.listeners = newObservers;
            } else {
                this.listeners = null;
            }
        }
    }
}
