package com.seeq.link.sdk.utilities;
import java.net.URL;
import java.net.URLClassLoader;

/**
 * Utility class allowing one to dynamically add entries to the classpath.
 */
public class ClassPathUtilities {

    private static volatile ClassPathUtilities instance;

    private final ConnectorsClassLoader classLoader;

    private ClassPathUtilities() {
        this.classLoader = new ConnectorsClassLoader(new URL[0], this.getClass().getClassLoader());
    }

    /**
     * Creates an instance of the class if it was not already created.
     * This class is a singleton.
     *
     * @return instance of the class
     */
    public static ClassPathUtilities instance() {
        if (instance == null) {
            instance = new ClassPathUtilities();
        }
        return instance;
    }

    /**
     * Returns the classloader that may be used to load resources and classes from the dynamic classpath
     *
     * @return the classloader
     */
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    /**
     * A classloader where addURL method is exposed
     */
    public static class ConnectorsClassLoader extends URLClassLoader {

        public ConnectorsClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        protected void addURL(URL url) {
            super.addURL(url);
        }
    }
}
