package com.seeq.link.sdk.utilities;

import org.jetbrains.annotations.NotNull;

/**
 * Object that may be used by a Datasource client for sending the
 * monitor results to the connection class.
 */
public class CheckResult {
    private final boolean success;
    private final String failMessage;

    /**
     * Creates a {@link CheckResult} object.
     * When success parameter is true the failMessage is discarded.
     * When success parameter is false the failMessage is stored in the object.
     */
    public CheckResult(boolean success, String failMessage) {
        this.success = success;
        this.failMessage = success ? "" : failMessage;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getFailMessage() {
        return this.failMessage;
    }

    /**
     * Builds a failure CheckResponse object with a failMessage.
     */
    @NotNull
    public static CheckResult buildFailure(String failMessage) {
        return new CheckResult(false, failMessage);
    }

    /**
     * Builds a success CheckResponse object having no failMessage.
     */
    @NotNull
    public static CheckResult buildSuccess() {
        return new CheckResult(true, "");
    }
}