package com.seeq.link.sdk.utilities;

import java.util.function.Supplier;

import javax.ws.rs.core.Response;

import com.seeq.ApiException;

public final class ApiRequestHelper {
    private ApiRequestHelper() {}

    /**
     * Returns the result of the API call passed as argument to this method.
     * If the API call throws a 404 (NOT_FOUND) it returns null.
     * ApiExceptions with a different status code are rethrown.
     */
    public static <T> T callNotFoundSafe(Supplier<T> function) {
        try {
            return function.get();
        } catch (ApiException e) {
            if (e.getCode() == Response.Status.NOT_FOUND.getStatusCode()) {
                return null;
            }
            throw e;
        }
    }
}
