package com.seeq.link.sdk.utilities;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;

import com.google.common.base.Preconditions;

import io.swagger.v3.oas.annotations.media.Schema;

public final class ApiModelHelper {
    private ApiModelHelper() {}

    public static void copySchemaProperties(Object source, Object target) {
        Arrays.stream(source.getClass().getMethods()).filter(ApiModelHelper::isSchemaGetter).forEach(
                method -> {
                    Preconditions.checkArgument(method.getName().startsWith("get"));
                    try {
                        Method setMethod = target.getClass().getMethod(method.getName().replaceFirst("get", "set"),
                                method.getReturnType());
                        setMethod.invoke(target, method.invoke(source, (Object[]) null));
                    } catch (NoSuchMethodException | InvocationTargetException | IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
        );
    }

    public static boolean isSchemaGetter(Method method) {
        return Modifier.isPublic(method.getModifiers()) &&
                method.isAnnotationPresent(Schema.class);
    }
}
