package com.seeq.link.sdk.utilities;

import java.net.InetAddress;
import java.net.UnknownHostException;

/**
 * Agent utilities
 */
public class AgentHelper {
    private final String agentName;
    private final String machineName;

    public AgentHelper(String agentName) {
        this.agentName = agentName;
        String machineName;
        try {
            machineName = InetAddress.getLocalHost().getHostName();
        } catch (UnknownHostException e) {
            machineName = "Unknown Machine Name";
        }
        this.machineName = machineName;
    }

    /**
     * Provides the agent identification string. This string allows appserver to uniquely identify any agent.
     */
    public String getAgentIdentification() {
        return String.format("%s: %s", this.agentName, this.machineName);
    }
}
