package com.seeq.link.sdk.services;

import com.seeq.model.UserGroupWithIdInputV1;
import com.seeq.utilities.SeeqNames;

public class TransformableUserGroup implements Transformable<UserGroupWithIdInputV1> {
    private final UserGroupWithIdInputV1 input;

    public TransformableUserGroup(UserGroupWithIdInputV1 input) {
        this.input = input;
    }

    public TransformableUserGroup() {
        this.input = new UserGroupWithIdInputV1();
    }

    @Override
    public Transformable<UserGroupWithIdInputV1> copy() {
        TransformableUserGroup copy = new TransformableUserGroup();

        String[] properties = new String[] {
                SeeqNames.Properties.DataId,
                SeeqNames.Properties.DatasourceClass,
                SeeqNames.Properties.DatasourceId,
                SeeqNames.Properties.RemoteGroupEditable,
                SeeqNames.Properties.RemovePermissions,
                SeeqNames.Properties.SyncToken,
                SeeqNames.Properties.Name,
                SeeqNames.Properties.Description
        };

        for (String propertyName : properties) {
            copy.setProperty(propertyName, this.getProperty(propertyName));
        }

        // We are not supporting transformers on mappings. At least not now.
        if (this.getInputObject().getMappings() != null) {
            copy.getInputObject().setMappings(this.getInputObject().getMappings());
        }

        copy.getInputObject().setIsEnabled(this.getInputObject().getIsEnabled());
        copy.getInputObject().setMapping(this.getInputObject().getMapping());
        return copy;
    }

    @Override
    public UserGroupWithIdInputV1 getInputObject() {
        return this.input;
    }

    @Override
    public Object getProperty(String propertyName) {
        if (propertyName.equals(SeeqNames.Properties.Type)) {
            return SeeqNames.Types.UserGroup;
        } else if (propertyName.equals(SeeqNames.Properties.DataId)) {
            return this.input.getDataId();
        } else if (propertyName.equals(SeeqNames.Properties.DatasourceClass)) {
            return this.input.getDatasourceClass();
        } else if (propertyName.equals(SeeqNames.Properties.DatasourceId)) {
            return this.input.getDatasourceId();
        } else if (propertyName.equals(SeeqNames.Properties.Description)) {
            return this.input.getDescription();
        } else if (propertyName.equals(SeeqNames.Properties.Name)) {
            return this.input.getName();
        } else if (propertyName.equals(SeeqNames.Properties.RemoteGroupEditable)) {
            return this.input.getRemoteGroupEditable();
        } else if (propertyName.equals(SeeqNames.Properties.RemovePermissions)) {
            return this.input.getRemovePermissions();
        } else if (propertyName.equals(SeeqNames.Properties.SyncToken)) {
            return this.input.getSyncToken();
        } else {
            return null;
        }
    }

    @Override
    public void setProperty(String propertyName, Object propertyValue, String unitOfMeasure) {
        if (propertyName.equals(SeeqNames.Properties.DataId)) {
            this.input.setDataId(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.DatasourceClass)) {
            this.input.setDatasourceClass(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.DatasourceId)) {
            this.input.setDatasourceId(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.Description)) {
            this.input.setDescription(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.Name)) {
            this.input.setName(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.RemoteGroupEditable)) {
            this.input.setRemoteGroupEditable((Boolean) propertyValue);
        } else if (propertyName.equals(SeeqNames.Properties.RemovePermissions)) {
            this.input.setRemovePermissions((Boolean) propertyValue);
        } else if (propertyName.equals(SeeqNames.Properties.SyncToken)) {
            this.input.setSyncToken(PropertyTransformer.toStr(propertyValue));
        }
    }

    @Override
    public String toString() {
        return String.format("UserGroup(name = %s, dataId = %s)", this.input.getName(), this.input.getDataId());
    }
}
