package com.seeq.link.sdk.services;

import java.util.ArrayList;
import java.util.List;

import com.seeq.model.ScalarPropertyV1;
import com.seeq.model.SignalWithIdInputV1;
import com.seeq.utilities.SeeqNames;

class TransformableSignal implements Transformable<SignalWithIdInputV1> {
    private final SignalWithIdInputV1 input;

    public TransformableSignal() {
        this.input = new SignalWithIdInputV1();
    }

    public TransformableSignal(SignalWithIdInputV1 input) {
        this.input = input;
    }

    @Override
    public Transformable<SignalWithIdInputV1> copy() {
        TransformableSignal output = new TransformableSignal();

        String[] properties = new String[] {
                SeeqNames.Properties.DataId,
                SeeqNames.Properties.DatasourceClass,
                SeeqNames.Properties.DatasourceId,
                SeeqNames.Properties.PreviousDataId,
                SeeqNames.Properties.Description,
                SeeqNames.Properties.Formula,
                SeeqNames.Properties.FormulaParameters,
                SeeqNames.Properties.InterpolationMethod,
                SeeqNames.Properties.HistoricalDataVersion,
                SeeqNames.Properties.KeyUom,
                SeeqNames.Properties.MaximumInterpolation,
                SeeqNames.Properties.Name,
                SeeqNames.Properties.NumberFormat,
                SeeqNames.Properties.ScopedTo,
                SeeqNames.Properties.SecurityString,
                SeeqNames.Properties.SourceSecurityString,
                SeeqNames.Properties.SyncToken,
                SeeqNames.Properties.ValueUom,
        };

        for (String property : properties) {
            output.setProperty(property, this.getProperty(property));
        }

        if (this.input.getAdditionalProperties() != null) {
            for (ScalarPropertyV1 inputProperty : this.input.getAdditionalProperties()) {
                output.setProperty(inputProperty.getName(), inputProperty.getValue(), inputProperty.getUnitOfMeasure());
            }
        }

        return output;
    }

    @Override
    public SignalWithIdInputV1 getInputObject() {
        return this.input;
    }

    @Override
    public Object getProperty(String propertyName) {
        if (propertyName.equals(SeeqNames.Properties.Type)) {
            return SeeqNames.Types.Signal;
        } else if (propertyName.equals(SeeqNames.Properties.DataId)) {
            return this.input.getDataId();
        } else if (propertyName.equals(SeeqNames.Properties.PreviousDataId)) {
            return this.input.getPreviousDataId();
        } else if (propertyName.equals(SeeqNames.Properties.DatasourceClass)) {
            return this.input.getDatasourceClass();
        } else if (propertyName.equals(SeeqNames.Properties.DatasourceId)) {
            return this.input.getDatasourceId();
        } else if (propertyName.equals(SeeqNames.Properties.Description)) {
            return this.input.getDescription();
        } else if (propertyName.equals(SeeqNames.Properties.Formula)) {
            return this.input.getFormula();
        } else if (propertyName.equals(SeeqNames.Properties.FormulaParameters)) {
            return this.input.getFormulaParameters();
        } else if (propertyName.equals(SeeqNames.Properties.InterpolationMethod)) {
            return this.input.getInterpolationMethod();
        } else if (propertyName.equals(SeeqNames.Properties.HistoricalDataVersion)) {
            return this.input.getHistoricalDataVersion();
        } else if (propertyName.equals(SeeqNames.Properties.KeyUom)) {
            return this.input.getKeyUnitOfMeasure();
        } else if (propertyName.equals(SeeqNames.Properties.MaximumInterpolation)) {
            return this.input.getMaximumInterpolation();
        } else if (propertyName.equals(SeeqNames.Properties.Name)) {
            return this.input.getName();
        } else if (propertyName.equals(SeeqNames.Properties.NumberFormat)) {
            return this.input.getNumberFormat();
        } else if (propertyName.equals(SeeqNames.Properties.ScopedTo)) {
            return this.input.getScopedTo();
        } else if (propertyName.equals(SeeqNames.Properties.SecurityString)) {
            return this.input.getSecurityString();
        } else if (propertyName.equals(SeeqNames.Properties.SourceSecurityString)) {
            return this.input.getSourceSecurityString();
        } else if (propertyName.equals(SeeqNames.Properties.SyncToken)) {
            return this.input.getSyncToken();
        } else if (propertyName.equals(SeeqNames.Properties.ValueUom)) {
            return this.input.getValueUnitOfMeasure();
        } else {
            if (this.input.getAdditionalProperties() == null) {
                return null;
            }

            ScalarPropertyV1 property = this.input.getAdditionalProperties().stream()
                    .filter(s -> s.getName().equals(propertyName))
                    .findFirst()
                    .orElse(null);

            return property == null ? null : property.getValue();
        }
    }

    @Override
    public void setProperty(String propertyName, Object propertyValue) {
        this.setProperty(propertyName, propertyValue, null);
    }

    @Override
    public void setProperty(String propertyName, Object propertyValue, String unitOfMeasure) {
        if (propertyName.equals(SeeqNames.Properties.DataId)) {
            this.input.setDataId(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.PreviousDataId)) {
            this.input.setPreviousDataId(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.DatasourceClass)) {
            this.input.setDatasourceClass(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.DatasourceId)) {
            this.input.setDatasourceId(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.Description)) {
            this.input.setDescription(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.Formula)) {
            this.input.setFormula(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.FormulaParameters)) {
            @SuppressWarnings("unchecked")
            List<String> parameterList = (List<String>) propertyValue;
            this.input.setFormulaParameters(parameterList);
        } else if (propertyName.equals(SeeqNames.Properties.InterpolationMethod)) {
            this.input.setInterpolationMethod(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.HistoricalDataVersion)) {
            this.input.setHistoricalDataVersion(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.KeyUom)) {
            this.input.setKeyUnitOfMeasure(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.MaximumInterpolation)) {
            if (unitOfMeasure != null && !(propertyValue instanceof String)) {
                // If someone is trying to set max interpolation via numeric + units, rather than a string with
                // embedded units, we convert it to a string here.
                propertyValue = PropertyTransformer.toStr(propertyValue) + PropertyTransformer.toStr(unitOfMeasure);
            }

            this.input.setMaximumInterpolation(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.Name)) {
            this.input.setName(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.NumberFormat)) {
            this.input.setNumberFormat(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.ScopedTo)) {
            this.input.setScopedTo(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.SecurityString)) {
            this.input.setSecurityString(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.SourceSecurityString)) {
            this.input.setSourceSecurityString(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.SyncToken)) {
            this.input.setSyncToken(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.ValueUom)) {
            this.input.setValueUnitOfMeasure(PropertyTransformer.toStr(propertyValue));
        } else {
            if (this.input.getAdditionalProperties() == null) {
                this.input.setAdditionalProperties(new ArrayList<>());
            }

            ScalarPropertyV1 property = this.input.getAdditionalProperties().stream()
                    .filter(s -> s.getName().equals(propertyName))
                    .findFirst()
                    .orElse(null);

            if (property == null) {
                property = new ScalarPropertyV1();
                property.setName(propertyName);
                this.input.addAdditionalPropertiesItem(property);
            }

            property.setValue(propertyValue);
            property.setUnitOfMeasure(unitOfMeasure);
        }
    }

    @Override
    public String toString() {
        return String.format("Signal(name = %s, dataId = %s)", this.input.getName(), this.input.getDataId());
    }
}
