package com.seeq.link.sdk.services;

import java.util.ArrayList;
import java.util.List;

import com.seeq.model.PutScalarInputV1;
import com.seeq.model.ScalarPropertyV1;
import com.seeq.utilities.SeeqNames;

class TransformableScalar implements Transformable<PutScalarInputV1> {
    private final PutScalarInputV1 input;

    public TransformableScalar() {
        this.input = new PutScalarInputV1();
    }

    public TransformableScalar(PutScalarInputV1 input) {
        this.input = input;
    }

    @Override
    public Transformable<PutScalarInputV1> copy() {
        TransformableScalar output = new TransformableScalar();

        String[] properties = new String[] {
                SeeqNames.Properties.DataId,
                SeeqNames.Properties.DatasourceClass,
                SeeqNames.Properties.DatasourceHostId,
                SeeqNames.Properties.DatasourceId,
                SeeqNames.Properties.Description,
                SeeqNames.Properties.Formula,
                SeeqNames.Properties.FormulaParameters,
                SeeqNames.Properties.Name,
                SeeqNames.Properties.NumberFormat,
                SeeqNames.Properties.PreviousDataId,
                SeeqNames.Properties.ScopedTo,
                SeeqNames.Properties.SyncToken,
                SeeqNames.Properties.Uom,
                SeeqNames.Properties.SecurityString,
                SeeqNames.Properties.SourceSecurityString
        };

        for (String property : properties) {
            output.setProperty(property, this.getProperty(property));
        }

        if (this.input.getProperties() != null) {
            for (ScalarPropertyV1 inputProperty : this.input.getProperties()) {
                output.setProperty(inputProperty.getName(), inputProperty.getValue(), inputProperty.getUnitOfMeasure());
            }
        }

        if (this.input.getAdditionalProperties() != null) {
            for (ScalarPropertyV1 additionalProperty : this.input.getAdditionalProperties()) {
                output.setAdditionalProperty(additionalProperty.getName(), additionalProperty.getValue(),
                        additionalProperty.getUnitOfMeasure());
            }
        }

        return output;
    }

    @Override
    public PutScalarInputV1 getInputObject() {
        return this.input;
    }

    @Override
    public Object getProperty(String propertyName) {
        if (propertyName.equals(SeeqNames.Properties.Type)) {
            return "Scalar";
        } else if (propertyName.equals(SeeqNames.Properties.DataId)) {
            return this.input.getDataId();
        } else if (propertyName.equals(SeeqNames.Properties.DatasourceClass)) {
            return this.input.getDatasourceClass();
        } else if (propertyName.equals(SeeqNames.Properties.DatasourceHostId)) {
            return this.input.getHostId();
        } else if (propertyName.equals(SeeqNames.Properties.DatasourceId)) {
            return this.input.getDatasourceId();
        } else if (propertyName.equals(SeeqNames.Properties.Description)) {
            return this.input.getDescription();
        } else if (propertyName.equals(SeeqNames.Properties.Formula)) {
            return this.input.getFormula();
        } else if (propertyName.equals(SeeqNames.Properties.FormulaParameters)) {
            return this.input.getParameters();
        } else if (propertyName.equals(SeeqNames.Properties.Name)) {
            return this.input.getName();
        } else if (propertyName.equals(SeeqNames.Properties.NumberFormat)) {
            return this.input.getNumberFormat();
        } else if (propertyName.equals(SeeqNames.Properties.PreviousDataId)) {
            return this.input.getPreviousDataId();
        } else if (propertyName.equals(SeeqNames.Properties.ScopedTo)) {
            return this.input.getScopedTo();
        } else if (propertyName.equals(SeeqNames.Properties.SyncToken)) {
            return this.input.getSyncToken();
        } else if (propertyName.equals(SeeqNames.Properties.Uom)) {
            return this.input.getUnitOfMeasure();
        } else if (propertyName.equals(SeeqNames.Properties.SourceSecurityString)) {
            return this.input.getSourceSecurityString();
        } else if (propertyName.equals(SeeqNames.Properties.SecurityString)) {
            return this.input.getSecurityString();
        } else {
            if (this.input.getProperties() == null) {
                return null;
            }

            ScalarPropertyV1 property = this.input.getProperties().stream()
                    .filter(s -> s.getName().equals(propertyName))
                    .findFirst()
                    .orElse(null);

            return property == null ? null : property.getValue();
        }
    }

    @Override
    public void setProperty(String propertyName, Object propertyValue) {
        this.setProperty(propertyName, propertyValue, null);
    }

    @Override
    public void setProperty(String propertyName, Object propertyValue, String unitOfMeasure) {
        if (propertyName.equals(SeeqNames.Properties.DataId)) {
            this.input.setDataId(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.DatasourceClass)) {
            this.input.setDatasourceClass(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.DatasourceHostId)) {
            this.input.setHostId(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.DatasourceId)) {
            this.input.setDatasourceId(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.Description)) {
            this.input.setDescription(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.Formula)) {
            this.input.setFormula(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.FormulaParameters)) {
            @SuppressWarnings("unchecked")
            List<String> parameterList = (List<String>) propertyValue;
            this.input.setParameters(parameterList);
        } else if (propertyName.equals(SeeqNames.Properties.Name)) {
            this.input.setName(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.NumberFormat)) {
            this.input.setNumberFormat(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.PreviousDataId)) {
            this.input.setPreviousDataId(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.ScopedTo)) {
            this.input.setScopedTo(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.SyncToken)) {
            this.input.setSyncToken(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.Uom)) {
            this.input.setUnitOfMeasure(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.SourceSecurityString)) {
            this.input.setSourceSecurityString(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.SecurityString)) {
            this.input.setSecurityString(PropertyTransformer.toStr(propertyValue));
        } else {
            if (this.input.getProperties() == null) {
                this.input.setProperties(new ArrayList<>());
            }

            ScalarPropertyV1 property = this.input.getProperties().stream()
                    .filter(s -> s.getName().equals(propertyName))
                    .findFirst()
                    .orElse(null);

            if (property == null) {
                property = new ScalarPropertyV1();
                property.setName(propertyName);
                this.input.addPropertiesItem(property);
            }

            property.setValue(propertyValue);
            property.setUnitOfMeasure(unitOfMeasure);
        }
    }

    private void setAdditionalProperty(String propertyName, Object propertyValue, String unitOfMeasure) {
        if (this.input.getAdditionalProperties() == null) {
            this.input.setAdditionalProperties(new ArrayList<>());
        }

        ScalarPropertyV1 property = this.input.getAdditionalProperties().stream()
                .filter(s -> s.getName().equals(propertyName))
                .findFirst()
                .orElse(null);

        if (property == null) {
            property = new ScalarPropertyV1();
            property.setName(propertyName);
            this.input.addAdditionalPropertiesItem(property);
        }

        property.setValue(propertyValue);
        property.setUnitOfMeasure(unitOfMeasure);
    }

    @Override
    public String toString() {
        return String.format("Scalar(name = %s, dataId = %s)", this.input.getName(), this.input.getDataId());
    }
}
