package com.seeq.link.sdk.services;

import java.util.ArrayList;
import java.util.List;

import com.seeq.model.CapsulePropertyInputV1;
import com.seeq.model.ConditionUpdateInputV1;
import com.seeq.model.ScalarPropertyV1;
import com.seeq.utilities.SeeqNames;

public class TransformableCondition implements Transformable<ConditionUpdateInputV1> {
    private final ConditionUpdateInputV1 input;

    public TransformableCondition() {
        this.input = new ConditionUpdateInputV1();
    }

    public TransformableCondition(ConditionUpdateInputV1 input) {
        this.input = input;
    }

    @Override
    public Transformable<ConditionUpdateInputV1> copy() {
        TransformableCondition output = new TransformableCondition();

        String[] properties = new String[] {
                SeeqNames.Properties.DataId,
                SeeqNames.Properties.DatasourceClass,
                SeeqNames.Properties.DatasourceHostId,
                SeeqNames.Properties.DatasourceId,
                SeeqNames.Properties.Description,
                SeeqNames.Properties.Formula,
                SeeqNames.Properties.FormulaParameters,
                SeeqNames.Properties.HistoricalDataVersion,
                SeeqNames.Properties.MaximumDuration,
                SeeqNames.Properties.Name,
                SeeqNames.Properties.PreviousDataId,
                SeeqNames.Properties.ReplaceCapsuleProperties,
                SeeqNames.Properties.ScopedTo,
                SeeqNames.Properties.SecurityString,
                SeeqNames.Properties.SourceSecurityString,
                SeeqNames.Properties.SyncToken,
                SeeqNames.Properties.Uom
        };

        for (String property : properties) {
            output.setProperty(property, this.getProperty(property));
        }

        if (this.input.getProperties() != null) {
            for (ScalarPropertyV1 inputProperty : this.input.getProperties()) {
                output.setProperty(inputProperty.getName(), inputProperty.getValue(), inputProperty.getUnitOfMeasure());
            }
        }

        if (this.input.getAdditionalProperties() != null) {
            for (ScalarPropertyV1 additionalProperty : this.input.getAdditionalProperties()) {
                output.setAdditionalProperty(additionalProperty.getName(), additionalProperty.getValue(),
                        additionalProperty.getUnitOfMeasure());
            }
        }

        if (this.input.getCapsuleProperties() != null) {
            for (CapsulePropertyInputV1 capsuleProperty : this.input.getCapsuleProperties()) {
                output.setCapsuleProperty(capsuleProperty.getName(), capsuleProperty.getUnitOfMeasure());
            }
        }

        return output;
    }

    @Override
    public ConditionUpdateInputV1 getInputObject() {
        return this.input;
    }

    @Override
    public Object getProperty(String propertyName) {
        if (propertyName.equals(SeeqNames.Properties.Type)) {
            return SeeqNames.Types.Condition;
        } else if (propertyName.equals(SeeqNames.Properties.DataId)) {
            return this.input.getDataId();
        } else if (propertyName.equals(SeeqNames.Properties.DatasourceClass)) {
            return this.input.getDatasourceClass();
        } else if (propertyName.equals(SeeqNames.Properties.DatasourceHostId)) {
            return this.input.getHostId();
        } else if (propertyName.equals(SeeqNames.Properties.DatasourceId)) {
            return this.input.getDatasourceId();
        } else if (propertyName.equals(SeeqNames.Properties.Description)) {
            return this.input.getDescription();
        } else if (propertyName.equals(SeeqNames.Properties.Formula)) {
            return this.input.getFormula();
        } else if (propertyName.equals(SeeqNames.Properties.FormulaParameters)) {
            return this.input.getParameters();
        } else if (propertyName.equals(SeeqNames.Properties.HistoricalDataVersion)) {
            return this.input.getHistoricalDataVersion();
        } else if (propertyName.equals(SeeqNames.Properties.MaximumDuration)) {
            return this.input.getMaximumDuration();
        } else if (propertyName.equals(SeeqNames.Properties.Name)) {
            return this.input.getName();
        } else if (propertyName.equals(SeeqNames.Properties.PreviousDataId)) {
            return this.input.getPreviousDataId();
        } else if (propertyName.equals(SeeqNames.Properties.ReplaceCapsuleProperties)) {
            return this.input.getReplaceCapsuleProperties();
        } else if (propertyName.equals(SeeqNames.Properties.ScopedTo)) {
            return this.input.getScopedTo();
        } else if (propertyName.equals(SeeqNames.Properties.SecurityString)) {
            return this.input.getSecurityString();
        } else if (propertyName.equals(SeeqNames.Properties.SourceSecurityString)) {
            return this.input.getSourceSecurityString();
        } else if (propertyName.equals(SeeqNames.Properties.SyncToken)) {
            return this.input.getSyncToken();
        } else if (propertyName.equals(SeeqNames.Properties.Uom)) {
            return this.input.getUnitOfMeasure();
        } else {
            if (this.input.getProperties() == null) {
                return null;
            }

            ScalarPropertyV1 property = this.input.getProperties().stream()
                    .filter(s -> s.getName().equals(propertyName))
                    .findFirst()
                    .orElse(null);

            return property == null ? null : property.getValue();
        }
    }

    @Override
    public void setProperty(String propertyName, Object propertyValue) {
        this.setProperty(propertyName, propertyValue, null);
    }

    @Override
    public void setProperty(String propertyName, Object propertyValue, String unitOfMeasure) {
        if (propertyName.equals(SeeqNames.Properties.DataId)) {
            this.input.setDataId(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.DatasourceClass)) {
            this.input.setDatasourceClass(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.DatasourceHostId)) {
            this.input.setHostId(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.DatasourceId)) {
            this.input.setDatasourceId(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.Description)) {
            this.input.setDescription(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.Formula)) {
            this.input.setFormula(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.FormulaParameters)) {
            @SuppressWarnings("unchecked")
            List<String> parameterList = (List<String>) propertyValue;
            this.input.setParameters(parameterList);
        } else if (propertyName.equals(SeeqNames.Properties.HistoricalDataVersion)) {
            this.input.setHistoricalDataVersion(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.MaximumDuration)) {
            if (unitOfMeasure != null && !(propertyValue instanceof String)) {
                // If someone is trying to set max duration via numeric + units, rather than a string with
                // embedded units, we convert it to a string here.
                propertyValue = PropertyTransformer.toStr(propertyValue) + PropertyTransformer.toStr(unitOfMeasure);
            }

            this.input.setMaximumDuration(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.Name)) {
            this.input.setName(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.PreviousDataId)) {
            this.input.setPreviousDataId(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.ReplaceCapsuleProperties)) {
            this.input.setReplaceCapsuleProperties((Boolean) propertyValue);
        } else if (propertyName.equals(SeeqNames.Properties.ScopedTo)) {
            this.input.setScopedTo(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.SecurityString)) {
            this.input.setSecurityString(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.SourceSecurityString)) {
            this.input.setSourceSecurityString(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.SyncToken)) {
            this.input.setSyncToken(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.Uom)) {
            this.input.setUnitOfMeasure(PropertyTransformer.toStr(propertyValue));
        } else {
            if (this.input.getProperties() == null) {
                this.input.setProperties(new ArrayList<>());
            }

            ScalarPropertyV1 property = this.input.getProperties().stream()
                    .filter(s -> s.getName().equals(propertyName))
                    .findFirst()
                    .orElse(null);

            if (property == null) {
                property = new ScalarPropertyV1();
                property.setName(propertyName);
                this.input.addPropertiesItem(property);
            }

            property.setValue(propertyValue);
            property.setUnitOfMeasure(unitOfMeasure);
        }
    }

    private void setAdditionalProperty(String propertyName, Object propertyValue, String unitOfMeasure) {
        if (this.input.getAdditionalProperties() == null) {
            this.input.setAdditionalProperties(new ArrayList<>());
        }

        ScalarPropertyV1 property = this.input.getAdditionalProperties().stream()
                .filter(s -> s.getName().equals(propertyName))
                .findFirst()
                .orElse(null);

        if (property == null) {
            property = new ScalarPropertyV1();
            property.setName(propertyName);
            this.input.addAdditionalPropertiesItem(property);
        }

        property.setValue(propertyValue);
        property.setUnitOfMeasure(unitOfMeasure);
    }

    private void setCapsuleProperty(String propertyName, String unitOfMeasure) {
        if (this.input.getCapsuleProperties() == null) {
            this.input.setCapsuleProperties(new ArrayList<>());
        }

        CapsulePropertyInputV1 property = this.input.getCapsuleProperties().stream()
                .filter(s -> s.getName().equals(propertyName))
                .findFirst()
                .orElse(null);

        if (property == null) {
            property = new CapsulePropertyInputV1();
            property.setName(propertyName);
            this.input.addCapsulePropertiesItem(property);
        }

        property.setUnitOfMeasure(unitOfMeasure);
    }

    @Override
    public String toString() {
        return String.format("Condition(name = %s, dataId = %s)", this.input.getName(), this.input.getDataId());
    }
}
