package com.seeq.link.sdk.services;

import java.util.ArrayList;

import com.seeq.model.PutAssetInputV1;
import com.seeq.model.ScalarPropertyV1;
import com.seeq.utilities.SeeqNames;

public class TransformableAsset implements Transformable<PutAssetInputV1> {
    private final PutAssetInputV1 input;

    public TransformableAsset() {
        this.input = new PutAssetInputV1();
    }

    public TransformableAsset(PutAssetInputV1 input) {
        this.input = input;
    }

    @Override
    public Transformable<PutAssetInputV1> copy() {
        TransformableAsset output = new TransformableAsset();

        String[] properties = new String[] {
                SeeqNames.Properties.DataId,
                SeeqNames.Properties.DatasourceHostId,
                SeeqNames.Properties.Description,
                SeeqNames.Properties.Name,
                SeeqNames.Properties.PreviousDataId,
                SeeqNames.Properties.ScopedTo,
                SeeqNames.Properties.SyncToken,
                SeeqNames.Properties.SecurityString,
                SeeqNames.Properties.SourceSecurityString
        };

        for (String property : properties) {
            output.setProperty(property, this.getProperty(property));
        }

        if (this.input.getProperties() != null) {
            for (ScalarPropertyV1 inputProperty : this.input.getProperties()) {
                output.setProperty(inputProperty.getName(), inputProperty.getValue(), inputProperty.getUnitOfMeasure());
            }
        }

        if (this.input.getAdditionalProperties() != null) {
            for (ScalarPropertyV1 additionalProperty : this.input.getAdditionalProperties()) {
                output.setAdditionalProperty(additionalProperty.getName(), additionalProperty.getValue(),
                        additionalProperty.getUnitOfMeasure());
            }
        }

        return output;
    }

    @Override
    public PutAssetInputV1 getInputObject() {
        return this.input;
    }

    @Override
    public Object getProperty(String propertyName) {
        if (propertyName.equals(SeeqNames.Properties.Type)) {
            return SeeqNames.Types.Asset;
        } else if (propertyName.equals(SeeqNames.Properties.DataId)) {
            return this.input.getDataId();
        } else if (propertyName.equals(SeeqNames.Properties.DatasourceHostId)) {
            return this.input.getHostId();
        } else if (propertyName.equals(SeeqNames.Properties.Description)) {
            return this.input.getDescription();
        } else if (propertyName.equals(SeeqNames.Properties.Name)) {
            return this.input.getName();
        } else if (propertyName.equals(SeeqNames.Properties.PreviousDataId)) {
            return this.input.getPreviousDataId();
        } else if (propertyName.equals(SeeqNames.Properties.ScopedTo)) {
            return this.input.getScopedTo();
        } else if (propertyName.equals(SeeqNames.Properties.SyncToken)) {
            return this.input.getSyncToken();
        } else if (propertyName.equals(SeeqNames.Properties.SourceSecurityString)) {
            return this.input.getSourceSecurityString();
        } else if (propertyName.equals(SeeqNames.Properties.SecurityString)) {
            return this.input.getSecurityString();
        } else {
            if (this.input.getProperties() == null) {
                return null;
            }

            ScalarPropertyV1 property = this.input.getProperties().stream()
                    .filter(s -> s.getName().equals(propertyName))
                    .findFirst()
                    .orElse(null);

            return property == null ? null : property.getValue();
        }
    }

    @Override
    public void setProperty(String propertyName, Object propertyValue) {
        this.setProperty(propertyName, propertyValue, null);
    }

    @Override
    public void setProperty(String propertyName, Object propertyValue, String unitOfMeasure) {
        if (propertyName.equals(SeeqNames.Properties.DataId)) {
            this.input.setDataId(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.DatasourceHostId)) {
            this.input.setHostId(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.Description)) {
            this.input.setDescription(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.Name)) {
            this.input.setName(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.PreviousDataId)) {
            this.input.setPreviousDataId(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.ScopedTo)) {
            this.input.setScopedTo(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.SyncToken)) {
            this.input.setSyncToken(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.SourceSecurityString)) {
            this.input.setSourceSecurityString(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals(SeeqNames.Properties.SecurityString)) {
            this.input.setSecurityString(PropertyTransformer.toStr(propertyValue));
        } else {
            if (this.input.getProperties() == null) {
                this.input.setProperties(new ArrayList<>());
            }

            ScalarPropertyV1 property = this.input.getProperties().stream()
                    .filter(s -> s.getName().equals(propertyName))
                    .findFirst()
                    .orElse(null);

            if (property == null) {
                property = new ScalarPropertyV1();
                property.setName(propertyName);
                this.input.addPropertiesItem(property);
            }

            property.setValue(propertyValue);
            property.setUnitOfMeasure(unitOfMeasure);
        }
    }

    private void setAdditionalProperty(String propertyName, Object propertyValue, String unitOfMeasure) {
        if (this.input.getAdditionalProperties() == null) {
            this.input.setAdditionalProperties(new ArrayList<>());
        }

        ScalarPropertyV1 property = this.input.getAdditionalProperties().stream()
                .filter(s -> s.getName().equals(propertyName))
                .findFirst()
                .orElse(null);

        if (property == null) {
            property = new ScalarPropertyV1();
            property.setName(propertyName);
            this.input.addAdditionalPropertiesItem(property);
        }

        property.setValue(propertyValue);
        property.setUnitOfMeasure(unitOfMeasure);
    }

    @Override
    public String toString() {
        return String.format("Asset(name = %s, dataId = %s)", this.input.getName(), this.input.getDataId());
    }
}
