package com.seeq.link.sdk.services;

/**
 * A common interface to wrap API input objects that can be modified by {@link PropertyTransformer}
 *
 * @param <T>
 *         The type of the input object to be transformed.
 */
public interface Transformable<T> {

    /**
     * Returns the value for the given property.
     *
     * @param propertyName
     *         The property to get.
     * @return The value, as a string, boolean, int or double.
     */
    Object getProperty(String propertyName);

    /**
     * Sets the value for the given property.
     *
     * @param propertyName
     *         The property to set.
     * @param propertyValue
     *         The value to set. Many properties are restricted to certain value types (e.g. 'Name'
     *         will almost always have to be a string).
     */
    default void setProperty(String propertyName, Object propertyValue) {
        this.setProperty(propertyName, propertyValue, null);
    }

    /**
     * Sets the value for the given property.
     *
     * @param propertyName
     *         The property to set.
     * @param propertyValue
     *         The value to set. Many properties are restricted to certain value types (e.g. 'Name'
     *         will almost always have to be a string).
     * @param unitOfMeasure
     *         The unit of measure to set on the property. Optional, and may be ignored for certain
     *         properties.
     */
    void setProperty(String propertyName, Object propertyValue, String unitOfMeasure);

    /**
     * Return a copy of this Transformable object.
     *
     * @return A copy of this object.
     */
    Transformable<T> copy();

    /**
     * Get the underlying API input object that backs this Transformable.
     *
     * @return A Seeq API input object.
     */
    T getInputObject();
}
