package com.seeq.link.sdk.services;

import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Consumer;

import com.seeq.link.sdk.ConfigObject;
import com.seeq.link.sdk.ConfigObjectWrapper;
import com.seeq.link.sdk.interfaces.FileConfigObjectProvider;
import com.seeq.utilities.FileChangeListener;

import lombok.extern.slf4j.Slf4j;

/**
 * FileConfigObjectProvider implementation that does not store the configuration anywhere.
 * When the configuration is loaded, the default config object is returned and the returned lastModified time is null.
 *
 * See {@link FileConfigObjectProvider} for documentation.
 */
@Slf4j
public class NoOpFileConfigObjectProvider implements FileConfigObjectProvider, FileChangeListener {
    public NoOpFileConfigObjectProvider() {}

    @Override
    public void initialize(Path dataPath) {
    }

    @Override
    public ConfigObjectWrapper loadConfigObject(String name, ConfigObject[] defaultConfigObjects) throws IOException {
        return JsonConfigObjectMapper.toConfigObjectWrapper(null, defaultConfigObjects,
                String.format("Could not deserialize json for \"%s\"", name), null);
    }

    @Override
    public void saveConfigObject(String name, Object configObject) {
    }

    @Override
    public void registerChangeCallback(String name, Consumer<String> callback) {
    }

    @Override
    public void unregisterChangeCallback(String name) {
    }

    @Override
    public void onFileModify(Path filePath) {
    }

    @Override
    public void onFileDelete(Path filePath) {
    }
}
