package com.seeq.link.sdk.services;

import java.io.IOException;
import java.util.function.Consumer;

import com.seeq.link.sdk.ConfigObject;
import com.seeq.link.sdk.interfaces.RemoteConfigObjectProvider;
import com.seeq.link.sdk.interfaces.ConfigService;
import com.seeq.link.sdk.interfaces.FileConfigObjectProvider;

import lombok.val;

/** See {@link ConfigService} for documentation. */
public class DefaultConfigService implements ConfigService {
    private FileConfigObjectProvider fileConfigObjectProvider;
    private RemoteConfigObjectProvider remoteConfigObjectProvider;

    @Override
    public void initialize(FileConfigObjectProvider fileConfigObjectProvider,
            RemoteConfigObjectProvider remoteConfigObjectProvider) {
        this.fileConfigObjectProvider = fileConfigObjectProvider;
        this.remoteConfigObjectProvider = remoteConfigObjectProvider;
    }

    /** Deprecated: All configuration should now come from configuration files. */
    @Override
    @Deprecated
    public String getGlobalArgument(String argumentName) {
        return null;
    }

    @Override
    public ConfigObject loadConfigObject(String name, ConfigObject[] defaultConfigObjects) throws IOException {
        val configWrapperFromFile = this.fileConfigObjectProvider.loadConfigObject(name, defaultConfigObjects);
        val configWrapperFromRemote = this.remoteConfigObjectProvider.loadConfigObject(name,
                defaultConfigObjects);

        if (configWrapperFromRemote.persistentAndNewerThan(configWrapperFromFile)) {
            return configWrapperFromRemote.getConfigObject();
        } else if (configWrapperFromFile.persistentAndNewerThan(configWrapperFromRemote)) {
            return configWrapperFromFile.getConfigObject();
        } else {
            return configWrapperFromRemote.getConfigObject();
        }
    }

    @Override
    public void saveConfigObject(String name, Object configObject) {
        this.fileConfigObjectProvider.saveConfigObject(name, configObject);
        this.remoteConfigObjectProvider.saveConfigObject(name, configObject);
    }

    @Override
    public void registerChangeCallback(String name, Consumer<String> callback) {
        this.fileConfigObjectProvider.registerChangeCallback(name, callback);
        this.remoteConfigObjectProvider.registerChangeCallback(name, callback);
    }

    @Override
    public void unregisterChangeCallback(String name) {
        this.fileConfigObjectProvider.unregisterChangeCallback(name);
        this.remoteConfigObjectProvider.unregisterChangeCallback(name);
    }
}
