package com.seeq.link.sdk.interfaces;

/**
 * Captures the state of sync'ing (aka indexing).
 */
public enum SyncStatus {
    /**
     * Connection has started up but there has been no sync yet.
     */
    SYNC_UNKNOWN,

    /**
     * Scheduler has kicked off a sync but the connection hasn't done anything yet.
     */
    SYNC_INITIALIZING,

    /**
     * Connection is actively sync'ing.
     */
    SYNC_IN_PROGRESS,

    /**
     * Connection has sync'd in {@link SyncMode#FULL} mode and is now archiving deleted items.
     */
    SYNC_ARCHIVING_DELETED_ITEMS,

    /**
     * Connection has finished sync'ing.
     */
    SYNC_COMPLETE,

    /**
     * Sync was a success and the next sync has been scheduled.
     */
    SYNC_SUCCESS,

    /**
     * Last sync was a failure and the next sync has been scheduled.
     */
    SYNC_FAILED
}
