package com.seeq.link.sdk.interfaces;

/**
 * Enumeration of possible index modes.
 */
public enum SyncMode {
    /**
     * Indicates that no sync is being requested.
     */
    NONE,

    /**
     * A FULL sync updates all items and deletes any items that no longer exist
     */
    FULL,

    /**
     * An INCREMENTAL sync updates only items that have changed and that still exist. Incremental syncs are faster, so
     * they can be performed more frequently without using too many resources on the Seeq server and source system.
     */
    INCREMENTAL
}
