package com.seeq.link.sdk.interfaces;

import java.util.stream.Stream;

import com.seeq.link.sdk.utilities.Sample;

/**
 * Implemented by connections that query their datasources for samples (within signals) on-demand when Seeq requires
 * data.
 *
 * Threading considerations:
 *
 * All methods may be called from different threads concurrently.
 */
public interface SignalPullDatasourceConnection extends PullDatasourceConnection {

    /**
     * Queries the external system for signal data.
     *
     * @param parameters
     *         A {@link GetSamplesParameters} object containing the parameters of the request. Consult the
     *         documentation for each field on that object for further information.
     * @return A stream used to retrieve the samples. A stream is used so the connection author can avoid loading
     *         all
     *         samples into memory, if the underlying datasource interface allows it. Streams can be created in a
     *         variety of ways, such as Guava's Streams.stream(iterable), Java's Stream.of(T... values), or
     *         Collection.stream().
     * @throws Exception
     *         All exceptions will get caught and the text of the exception will be set as the user visible status.
     */
    Stream<Sample> getSamples(GetSamplesParameters parameters) throws Exception;
}
