package com.seeq.link.sdk.interfaces;

import java.time.Duration;

import com.seeq.ApiClient;
import com.seeq.api.AgentsApi;
import com.seeq.api.AssetsApi;
import com.seeq.api.AuthApi;
import com.seeq.api.ConditionsApi;
import com.seeq.api.DatasourcesApi;
import com.seeq.api.FormulasApi;
import com.seeq.api.ItemsApi;
import com.seeq.api.RequestsApi;
import com.seeq.api.ScalarsApi;
import com.seeq.api.SignalsApi;
import com.seeq.api.SystemApi;
import com.seeq.api.TreesApi;
import com.seeq.api.UserGroupsApi;
import com.seeq.api.UsersApi;

/**
 * Provides methods to construct Seeq API objects.
 *
 * NOTE:
 *
 * Each API interface is exposed separately so that they can be mocked. Because of the structure of the swagger-codegen
 * output, we can't just mock the ApiClient and be done with it.
 */
public interface SeeqApiProvider {
    /**
     * Get an ApiClient instance for lower-level control of requests to the Seeq API.
     *
     * @return An ApiClient instance for lower-level control of requests to the Seeq API.
     */
    ApiClient getApiClient();

    /**
     * Sets a new connect timeout for the HTTP client used by the SeeqApiProvider.
     * The default connect timeout is 30min.
     *
     * @param connectTimeout
     *         The connect timeout to set
     */
    void setConnectTimeout(Duration connectTimeout);

    /**
     * Sets a new read timeout for the HTTP client used by the SeeqApiProvider.
     * The default read timeout is 30min.
     *
     * @param readTimeout
     *         The read timeout to set
     */
    void setReadTimeout(Duration readTimeout);

    /**
     * Sets a new retry timeout for a SeeqApiProvider
     *
     * @param retryTimeout
     *         Retry Timeout
     */
    void setRetryTimeout(Duration retryTimeout);

    /**
     * A SignalsApi interface to the Seeq Server.
     *
     * @return A SignalsApi interface to the Seeq Server.
     */
    SignalsApi createSignalsApi();

    /**
     * A ConditionsApi interface to the Seeq Server.
     *
     * @return A ConditionsApi interface to the Seeq Server.
     */
    ConditionsApi createConditionsApi();

    /**
     * A DatasourcesApi interface to the Seeq Server.
     *
     * @return A DatasourcesApi interface to the Seeq Server.
     */
    DatasourcesApi createDatasourcesApi();

    /**
     * An ItemsApi interface to the Seeq Server.
     *
     * @return An ItemsApi interface to the Seeq Server.
     */
    ItemsApi createItemsApi();

    /**
     * An AssetsApi interface to the Seeq Server.
     *
     * @return An AssetsApi interface to the Seeq Server.
     */
    AssetsApi createAssetsApi();

    /**
     * A TreesApi interface to the Seeq Server.
     *
     * @return A TreesApi interface to the Seeq Server.
     */
    TreesApi createTreesApi();

    /**
     * A SystemApi interface to the Seeq Server.
     *
     * @return A SystemApi interface to the Seeq Server.
     */
    SystemApi createSystemApi();

    /**
     * An AgentsApi interface to the Seeq Server.
     *
     * @return An AgentsApi interface to the Seeq Server.
     */
    AgentsApi createAgentsApi();

    /**
     * An AuthApi interface to the Seeq Server.
     *
     * @return An AuthApi interface to the Seeq Server.
     */
    AuthApi createAuthApi();

    /**
     * An RequestsApi interface to the Seeq Server.
     *
     * @return An RequestsApi interface to the Seeq Server.
     */
    RequestsApi createRequestsApi();

    /**
     * A ScalarsApi interface to the Seeq Server.
     *
     * @return A ScalarsApi interface to the Seeq Server.
     */
    ScalarsApi createScalarsApi();

    /**
     * A UserGroupsApi interface to the Seeq Server.
     *
     * @return A UserGroupsApi interface to the Seeq Server.
     */
    UserGroupsApi createUserGroupsApi();

    /**
     * A UsersApi interface to the Seeq Server.
     *
     * @return A UsersApi interface to the Seeq Server.
     */
    UsersApi createUsersApi();

    /**
     * A FormulasApi interface to the Seeq Server.
     *
     * @return A FormulasApi interface to the Seeq Server.
     */
    FormulasApi createFormulasApi();

    /**
     * Logs the current client out.
     */
    void logout();
}
