package com.seeq.link.sdk.interfaces;

import java.util.function.Consumer;

/**
 * Used to retrieve/persist remote configuration.
 */
public interface RemoteConfigObjectProvider extends ConfigObjectProvider, RemoteConfigChangeListener {
    /**
     * Initializes the provider with a seeq api provider to persist config objects to.
     */
    void initialize(SeeqApiProvider apiProvider, String agentName);

    /**
     * Registers a callback for when the configuration has changed.
     *
     * @param name
     *         Name of the configuration object you're interested in.
     * @param callback
     *         Callback function that takes the name as its only parameter.
     */
    void registerChangeCallback(String name, Consumer<String> callback);

    /**
     * Unregisters a callback previously registered.
     *
     * @param name
     *         Name of the configuration object you're interested in.
     */
    void unregisterChangeCallback(String name);
}
