package com.seeq.link.sdk.interfaces;

/**
 * Implemented by connections that query their datasources on-demand when Seeq requires data.
 */
public interface PullDatasourceConnection extends IndexingDatasourceConnection {
    /**
     * The maximum number of sample/capsule requests that will be processed simultaneously. This value will usually
     * come from the connector's configuration file. Return null if you do not wish to impose a limit.
     */
    Integer getMaxConcurrentRequests();

    /**
     * The maximum number of sample/capsule results that can be returned by a request. This value will usually
     * come from the connector's configuration file. Return null if you do not wish to impose a limit.
     */
    Integer getMaxResultsPerRequest();
}
