package com.seeq.link.sdk.interfaces;

import com.seeq.link.sdk.DefaultIndexingDatasourceConnectionConfig;

/**
 * This interface defines the functions that must be implemented by the class that facilitates a
 * connection to an external system that is indexed periodically.
 *
 * Threading considerations:
 *
 * Index() is called on its own thread. Index() calls are always on the same thread and therefore sequential.
 */
public interface IndexingDatasourceConnection extends DatasourceConnectionV2 {

    /**
     * The connector's configuration, which should extend {@link DefaultIndexingDatasourceConnectionConfig}. This is
     * used for access to required config fields like {@link com.seeq.link.sdk.IndexingSchedule}.
     */
    DefaultIndexingDatasourceConnectionConfig getConfiguration();

    /**
     * Queries appropriate items from the external system and makes index entries for them in Seeq.
     *
     * @param syncMode
     *         Indicates whether to perform a full or incremental sync.
     * @throws Exception
     *         All exceptions will get caught and the text of the exception will be set as the user visible status.
     */
    void index(SyncMode syncMode) throws Exception;
}
