package com.seeq.link.sdk.interfaces;

import java.nio.file.Path;
import java.util.function.Consumer;

/**
 * Used to persist config objects to/from disk.
 */
public interface FileConfigObjectProvider extends ConfigObjectProvider {

    /**
     * Initializes the provider with a data path to persist config objects to.
     *
     * @param dataPath
     *         The data path to persist config objects to.
     */
    void initialize(Path dataPath);

    /**
     * Registers a callback for when the configuration has changed.
     *
     * @param name
     *         Name of the configuration object you're interested in.
     * @param callback
     *         Callback function that takes the name as its only parameter.
     */
    void registerChangeCallback(String name, Consumer<String> callback);

    /**
     * Unregisters a callback previously registered.
     *
     * @param name
     *         Name of the configuration object you're interested in.
     */
    void unregisterChangeCallback(String name);
}
