package com.seeq.link.sdk.interfaces;

/**
 * <p>
 * This interface defines the functions that must be implemented by the class that manages connections to external
 * systems.
 * </p>
 * <p>
 * Connectors are loaded via the {@link java.util.ServiceLoader} mechanism. They need to be registered
 * under {@code META-INF/services/com.seeq.link.sdk.interfaces.ConnectorV2}
 * </p>
 */
public interface ConnectorV2 {

    /**
     * The name of the connector, as determined by the connector. This name will be used for the configuration file
     * name.
     *
     * @return connector name
     */
    String getName();

    /**
     * Called by the host to initialize a connector with the connector service interface it will use to accomplish tasks
     * like adding connections. The implementation of this function can choose to automatically define and/or establish
     * connections based on a global registry (like the PI "Known Servers Table").
     *
     * @param connectorService
     *         The services provided to facilitate common connector functionality.
     * @throws Exception
     *         Thrown if the connector could not initialize correctly. For example, an exception will be thrown if
     *         the configuration file could not be read.
     */
    void initialize(ConnectorServiceV2 connectorService) throws Exception;

    /**
     * Called by the host to destroy a connector. The connector should use the opportunity to clean up or
     * and close any resources it is holding open, and shut down any threads it may have spawned. All
     * Connections will have already been destroyed by the time this is called.
     */
    void destroy();
}
