package com.seeq.link.sdk.interfaces;

import java.util.stream.Stream;

import com.seeq.link.sdk.utilities.Capsule;
import com.seeq.link.sdk.utilities.TimeInstant;

/**
 * Implemented by connections that query their datasources for capsules (within conditions) on-demand when Seeq
 * requires data.
 *
 * Threading considerations:
 *
 * All methods may be called from different threads concurrently.
 */
public interface ConditionPullDatasourceConnection extends PullDatasourceConnection {
    /**
     * Queries the external system for the capsules in a condition.
     *
     * Note that if this method is implemented, {@link GetCapsulesParameters#setLastCertainKey(TimeInstant)} must be
     * invoked if {@link GetCapsulesParameters#isLastCertainKeyRequested()} returns {@code true}, or all capsules
     * returned will appear uncertain in Seeq.
     *
     * @param parameters
     *         A {@link GetCapsulesParameters} object containing the parameters of the request. Consult the
     *         documentation for each field on that object for further information.
     * @return A stream used to retrieve the capsules. A stream is used so the connection author can avoid loading all
     *         capsules into memory, if the underlying datasource interface allows it. Streams can be created in a
     *         variety of ways, such as Guava's Streams.stream(iterable), Java's Stream.of(T... values), or
     *         Collection.stream().
     * @throws Exception
     *         All exceptions will get caught and the text of the exception will be set as the user visible status.
     */
    Stream<Capsule> getCapsules(GetCapsulesParameters parameters) throws Exception;
}
