package com.seeq.link.sdk.interfaces;

import javax.annotation.Nullable;

import lombok.Data;

/**
 * The parameters used in the authorization request
 */
@Data
public class AuthParameters {
    @Nullable
    String username;
    String password;

    // Windows Authentication sometimes requires multiple client-to-server round-trips, but they must be handled as a
    // sequence. To identify which sequence a message belongs to, we use an unique identifier per client.
    @Nullable
    String sequenceId;
}
