package com.seeq.link.sdk.export;

import com.seeq.link.sdk.interfaces.GetSamplesParameters;
import com.seeq.link.sdk.utilities.Sample;
import com.seeq.link.sdk.utilities.TimeInstant;

import lombok.Getter;

/**
 * A rough complement of GetSamplesParameters, this class supplies the
 * arguments for the ExportSamples.PutSamples(PutSamplesParameters) method.
 * A class is used here so that the arguments can change slightly without breaking
 * compatibility.
 *
 * @see GetSamplesParameters
 * @see ExportSamples
 */
public class PutSamplesParameters {

    /**
     * The name of the destination signal/tag/point
     */
    @Getter
    private final String name;

    /**
     * The Seeq ID of the calculated item being exported
     */
    @Getter
    private final String id;

    /**
     * The units of measure of the calculated item
     */
    @Getter
    private final String uom;

    /**
     * true if the calculated item is step interpolated, otherwise false
     */
    @Getter
    private final boolean step;

    @Getter
    private final boolean clean;

    @Getter
    private final boolean verbose;

    /**
     * The left (earliest) time boundary for the write operation. Note that this is not
     * necessarily the left-most sample's time -- rather this is the "left-hand" side of
     * the time range covered by the write operation. This is important for responding to
     * the CLEAN clause, as you must know how far back to erase data.
     */
    @Getter
    private final TimeInstant startTime;

    /**
     * The right (latest) time boundary for the write operation. Note that this is not
     * necessarily the right-most sample's time -- rather this is the "right-hand" side of
     * the time range covered by the write operation.
     */
    @Getter
    private final TimeInstant endTime;

    /**
     * An enumeration of the samples to write.
     */
    @Getter
    private final Iterable<Sample> samples;

    public PutSamplesParameters(
            String name,
            String id,
            String uom,
            boolean step,
            TimeInstant startTime,
            TimeInstant endTime,
            Iterable<Sample> samples,
            boolean clean,
            boolean verbose
    ) {
        this.name = name;
        this.id = id;
        this.uom = uom;
        this.step = step;
        this.startTime = startTime;
        this.endTime = endTime;
        this.samples = samples;
        this.clean = clean;
        this.verbose = verbose;
    }
}
