package com.seeq.link.sdk.export;

import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * Extends ThreadPoolExecutor to have three named queues (fast, normal, slow).
 */
public class ExportTaskScheduler extends ThreadPoolExecutor implements AutoCloseable {
    public ExportTaskScheduler(int maxConcurrencyLevel) {
        super(maxConcurrencyLevel, maxConcurrencyLevel, 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<>());
    }

    public enum Queue {
        Fast,
        Normal,
        Slow
    }

    public Future<?> queueTask(ExportTask task, Queue queue) {
        task.setPriority(queue.ordinal());
        return this.submit(task);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new ExportFutureTask<>(runnable);
    }

    @Override
    public void close() {
        this.shutdownNow();
    }
}
