package com.seeq.link.sdk.export;

import javax.annotation.Nonnull;

import lombok.AccessLevel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

@Data
public class ExportTask implements Runnable {
    @Getter(AccessLevel.NONE)
    @Setter(AccessLevel.NONE)
    private final Runnable runnable;

    private int priority = 0;

    public ExportTask(@Nonnull Runnable runnable) {
        this.runnable = runnable;
    }

    @Override
    public void run() {
        this.runnable.run();
    }
}
