package com.seeq.link.sdk.export;

import com.seeq.link.sdk.utilities.TimeInstant;

/**
 * This interface defines the functions that must be implemented by the class that facilitates
 * exporting of signal data from Seeq to the datasource.
 *
 * If your connector can write signal data to the datasource, you can implement this interface
 * and then call DatasourceConnectionServiceV2.InitializeExport(IExportSamples, ExportConnectionConfigV1)
 * passing in the connection and an ExportConnectionConfigV1 Object, which is usually
 * found on the connection's configuration Object as the "Export" property.
 *
 * The connector should honor all of the configuration on ExportConnectionConfigV1.
 *
 * Additionally, it may choose to honor ApprovalExportConnectionConfigV1 including
 * AutoCreate, AutoUpdate, and RequireApproval. Use the
 * ApprovalExportConnectionConfigV1.AddNewOrChangedToConfig(String, Dictionary{String, object}),
 * ApprovalExportConnectionConfigV1.IsCreationApproved(String),
 * ApprovalExportConnectionConfigV1.IsUpdateApproved(String),
 * ApprovalExportConnectionConfigV1.RemoveNewOrChangedFromConfig(String) functions
 * appropriately.
 *
 * @see ExportConnectionConfigV1
 */
public interface ExportSamples {

    /**
     * Called by the datasource connection host when a signal should be written to. The
     * PutSamplesParameters Object contains all of the necessary information for
     * both the signal metadata and the time series data as well. The connector is expected
     * to create the signal if it doesn't exist (and it has been authorized in the Export
     * config) and write the samples.
     *
     * @param parameters
     *         The parameters for the signal and its data. See PutSamplesParameters for
     *         more information.
     * @throws RuntimeException
     *         Throw a RuntimeException for any error that you want passed back to the user
     *         via the "Export - Message" item property on the exported signal in Seeq.
     * @see PutSamplesParameters
     */
    void putSamples(PutSamplesParameters parameters);

    /**
     * Some historians, like certain versions of OSIsoft PI, don't like it if you try to
     * write data past a certain time. As an example, for OSIsoft PI, this function should
     * return PIServer.ServerTime.
     *
     * @param signalName
     *         The name of the signal for which a write operation is pending
     * @return The latest time for which signal data can be written. Return null if there
     *         is no restriction.
     */
    TimeInstant getLatestAllowedWriteTime(String signalName);
}
