package com.seeq.link.sdk.export;

import java.util.concurrent.FutureTask;

public class ExportFutureTask<T> extends FutureTask<T> implements Comparable<ExportFutureTask<T>> {

    private final ExportTask task;

    public ExportFutureTask(Runnable task) {
        super(task, null);

        if (!(task instanceof ExportTask)) {
            throw new IllegalArgumentException("task argument must be of type ExportTask");
        }

        this.task = (ExportTask) task;
    }

    @Override
    public int compareTo(ExportFutureTask<T> that) {
        return Integer.compare(this.task.getPriority(), that.task.getPriority());
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ExportFutureTask)) {
            return false;
        }

        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
