package com.seeq.link.sdk.export;

import java.time.Duration;
import java.util.IllegalFormatException;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.seeq.link.sdk.utilities.TimeInterval;

import lombok.Data;

/**
 * Used by any connection that supports export of Seeq calculated data to the datasource.
 */
@Data
public class ExportConnectionConfigV1 {
    private boolean enabled;
    private String minimumLatency = "15m";
    private String directiveRefreshFrequency = "15m";

    /**
     * Returns a Duration representing the DirectiveRefreshFrequency time interval.
     *
     * @return A Duration representing the DirectiveRefreshFrequency time interval
     * @throws IllegalFormatException
     *         If the DirectiveRefreshFrequency could not be parsed as a time
     *         interval
     */
    @JsonIgnore
    public Duration getDirectiveRefreshFrequencyAsDuration() {
        return TimeInterval.parseFriendlyDuration(this.directiveRefreshFrequency);
    }

    /**
     * Returns a Duration representing the MinimumLatency time interval.
     *
     * @return A Duration representing the MinimumLatency time interval
     * @throws IllegalFormatException
     *         If the MinimumLatency could not be parsed as a time interval
     */
    @JsonIgnore
    public Duration getMinimumLatencyAsDuration() {
        return TimeInterval.parseFriendlyDuration(this.minimumLatency);
    }

}
